/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.File;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SolrProducer.class);
    private SolrServer solrServer;

    public SolrProducer(SolrEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.solrServer = endpoint.getSolrServer();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = (String)exchange.getIn().getHeader("SolrOperation");
        if (operation == null) {
            throw new IllegalArgumentException("SolrOperation header is missing");
        }
        if (operation.equalsIgnoreCase("INSERT")) {
            this.insert(exchange);
        } else if (operation.equalsIgnoreCase("DELETE_BY_ID")) {
            this.solrServer.deleteById((String)exchange.getIn().getBody(String.class));
        } else if (operation.equalsIgnoreCase("DELETE_BY_QUERY")) {
            this.solrServer.deleteByQuery((String)exchange.getIn().getBody(String.class));
        } else if (operation.equalsIgnoreCase("ADD_BEAN")) {
            this.solrServer.addBean(exchange.getIn().getBody());
        } else if (operation.equalsIgnoreCase("COMMIT")) {
            this.solrServer.commit();
        } else if (operation.equalsIgnoreCase("ROLLBACK")) {
            this.solrServer.rollback();
        } else if (operation.equalsIgnoreCase("OPTIMIZE")) {
            this.solrServer.optimize();
        } else {
            throw new IllegalArgumentException("SolrOperation header value '" + operation + "' is not supported");
        }
    }

    private void insert(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (body instanceof File) {
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler());
            updateRequest.addFile((File)body);
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
                String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
                updateRequest.setParam(paramName, entry.getValue().toString());
            }
            updateRequest.process(this.solrServer);
        } else {
            SolrInputDocument doc = new SolrInputDocument();
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                String fieldName = ((String)entry.getKey()).substring("SolrField.".length());
                doc.setField(fieldName, entry.getValue());
            }
            UpdateRequest updateRequest = new UpdateRequest(this.getRequestHandler());
            updateRequest.add(doc);
            updateRequest.process(this.solrServer);
        }
    }

    private String getRequestHandler() {
        String requestHandler = this.getEndpoint().getRequestHandler();
        return requestHandler == null ? "/update" : requestHandler;
    }

    public SolrEndpoint getEndpoint() {
        return (SolrEndpoint)super.getEndpoint();
    }
}

