/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.ws.Holder;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;

public class HdfsInputStream
implements Closeable {
    private HdfsFileType fileType;
    private String actualPath;
    private String suffixedPath;
    private Closeable in;
    private boolean opened;
    private int chunkSize;
    private final AtomicLong numOfReadBytes = new AtomicLong(0L);
    private final AtomicLong numOfReadMessages = new AtomicLong(0L);

    protected HdfsInputStream() {
    }

    public static HdfsInputStream createInputStream(String hdfsPath, HdfsConfiguration configuration) throws IOException {
        HdfsInputStream ret = new HdfsInputStream();
        ret.fileType = configuration.getFileType();
        ret.actualPath = hdfsPath;
        ret.suffixedPath = ret.actualPath + '.' + configuration.getOpenedSuffix();
        ret.chunkSize = configuration.getChunkSize();
        HdfsInfo info = new HdfsInfo(ret.actualPath);
        info.getFileSystem().rename(new Path(ret.actualPath), new Path(ret.suffixedPath));
        ret.in = ret.fileType.createInputStream(ret.suffixedPath, configuration);
        ret.opened = true;
        return ret;
    }

    @Override
    public final void close() throws IOException {
        if (this.opened) {
            IOUtils.closeStream((Closeable)this.in);
            HdfsInfo info = new HdfsInfo(this.actualPath);
            info.getFileSystem().rename(new Path(this.suffixedPath), new Path(this.actualPath + '.' + "read"));
            this.opened = false;
        }
    }

    public final long next(Holder<Object> key, Holder<Object> value) {
        long nb = this.fileType.next(this, key, value);
        if (nb > 0L) {
            this.numOfReadBytes.addAndGet(nb);
            this.numOfReadMessages.incrementAndGet();
        }
        return nb;
    }

    public final long getNumOfReadBytes() {
        return this.numOfReadBytes.longValue();
    }

    public final long getNumOfReadMessages() {
        return this.numOfReadMessages.longValue();
    }

    public final String getActualPath() {
        return this.actualPath;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    public final Closeable getIn() {
        return this.in;
    }
}

