/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dozer.Mapping;
import org.dozer.MappingException;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.DozerClass;
import org.dozer.fieldmap.DozerField;
import org.dozer.fieldmap.GenericFieldMap;
import org.dozer.fieldmap.MapFieldMap;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassMapBuilder {
    private static final String CLASS = "class";
    private static final String CALLBACK = "callback";
    private static final String CALLBACKS = "callbacks";
    static final List<ClassMappingGenerator> buildTimeGenerators = new ArrayList<ClassMappingGenerator>();
    static final List<ClassMappingGenerator> runTimeGenerators = new ArrayList<ClassMappingGenerator>();

    private ClassMapBuilder() {
    }

    public static ClassMap createDefaultClassMap(Configuration globalConfiguration, Class<?> srcClass, Class<?> destClass) {
        ClassMap classMap = new ClassMap(globalConfiguration);
        classMap.setSrcClass(new DozerClass(srcClass.getName(), srcClass, globalConfiguration.getBeanFactory(), null, null, null, null, true, true, false));
        classMap.setDestClass(new DozerClass(destClass.getName(), destClass, globalConfiguration.getBeanFactory(), null, null, null, null, true, true, false));
        ClassMapBuilder.generateMapping(classMap, globalConfiguration, buildTimeGenerators);
        return classMap;
    }

    public static void addDefaultFieldMappings(ClassMappings classMappings, Configuration globalConfiguration) {
        Set<Map.Entry<String, ClassMap>> entries = classMappings.getAll().entrySet();
        for (Map.Entry<String, ClassMap> entry : entries) {
            ClassMap classMap = entry.getValue();
            ClassMapBuilder.generateMapping(classMap, globalConfiguration, runTimeGenerators);
        }
    }

    private static void generateMapping(ClassMap classMap, Configuration configuration, List<ClassMappingGenerator> mappingGenerators) {
        if (!classMap.isWildcard()) {
            return;
        }
        for (ClassMappingGenerator generator : mappingGenerators) {
            if (!generator.accepts(classMap) || !generator.apply(classMap, configuration)) continue;
            return;
        }
    }

    static boolean shouldIgnoreField(String fieldName, Class<?> srcType, Class<?> destType) {
        if (CLASS.equals(fieldName)) {
            return true;
        }
        return !(!CALLBACK.equals(fieldName) && !CALLBACKS.equals(fieldName) || !MappingUtils.isProxy(srcType) && !MappingUtils.isProxy(destType));
    }

    private static void addFieldMapping(ClassMap classMap, Configuration configuration, String srcName, String destName) {
        GenericFieldMap fieldMap = new GenericFieldMap(classMap);
        DozerField sourceField = new DozerField(srcName, null);
        DozerField destField = new DozerField(destName, null);
        sourceField.setAccessible(true);
        destField.setAccessible(true);
        fieldMap.setSrcField(sourceField);
        fieldMap.setDestField(destField);
        MappingUtils.applyGlobalCopyByReference(configuration, fieldMap, classMap);
        classMap.addFieldMapping(fieldMap);
    }

    private static void addGenericMapping(ClassMap classMap, Configuration configuration, String srcName, String destName) {
        GenericFieldMap fieldMap = new GenericFieldMap(classMap);
        fieldMap.setSrcField(new DozerField(srcName, null));
        fieldMap.setDestField(new DozerField(destName, null));
        MappingUtils.applyGlobalCopyByReference(configuration, fieldMap, classMap);
        classMap.addFieldMapping(fieldMap);
    }

    private static void validate(Mapping annotation, Member member) {
        if (annotation.value().trim().equals("")) {
            throw new MappingException("Mapping annotation value missing at " + member.getDeclaringClass().getName() + "." + member.getName());
        }
    }

    static {
        buildTimeGenerators.add(new AnnotationPropertiesGenerator());
        buildTimeGenerators.add(new AnnotationFieldsGenerator());
        buildTimeGenerators.add(new MapMappingGenerator());
        buildTimeGenerators.add(new BeanMappingGenerator());
        buildTimeGenerators.add(new CollectionMappingGenerator());
        runTimeGenerators.add(new AnnotationPropertiesGenerator());
        runTimeGenerators.add(new AnnotationFieldsGenerator());
        runTimeGenerators.add(new MapMappingGenerator());
        runTimeGenerators.add(new BeanMappingGenerator());
    }

    public static class AnnotationFieldsGenerator
    implements ClassMappingGenerator {
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        public boolean apply(ClassMap classMap, Configuration configuration) {
            Field[] destFields;
            Field[] srcFields;
            Class<?> srcType = classMap.getSrcClassToMap();
            for (Field field : srcFields = srcType.getDeclaredFields()) {
                Mapping mapping = field.getAnnotation(Mapping.class);
                String fieldName = field.getName();
                if (mapping == null) continue;
                ClassMapBuilder.validate(mapping, field);
                String pairName = mapping.value();
                ClassMapBuilder.addFieldMapping(classMap, configuration, fieldName, pairName);
            }
            Class<?> destType = classMap.getDestClassToMap();
            for (Field field : destFields = destType.getDeclaredFields()) {
                Mapping mapping = field.getAnnotation(Mapping.class);
                String fieldName = field.getName();
                if (mapping == null) continue;
                ClassMapBuilder.validate(mapping, field);
                String pairName = mapping.value();
                ClassMapBuilder.addFieldMapping(classMap, configuration, pairName, fieldName);
            }
            return false;
        }
    }

    public static class AnnotationPropertiesGenerator
    implements ClassMappingGenerator {
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] destProperties;
            PropertyDescriptor[] srcProperties;
            Class<?> srcType = classMap.getSrcClassToMap();
            for (PropertyDescriptor property : srcProperties = ReflectionUtils.getPropertyDescriptors(srcType)) {
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Mapping mapping = readMethod.getAnnotation(Mapping.class);
                String propertyName = property.getName();
                if (mapping == null) continue;
                ClassMapBuilder.validate(mapping, readMethod);
                String pairName = mapping.value();
                ClassMapBuilder.addGenericMapping(classMap, configuration, propertyName, pairName);
            }
            Class<?> destType = classMap.getDestClassToMap();
            for (PropertyDescriptor property : destProperties = ReflectionUtils.getPropertyDescriptors(destType)) {
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Mapping mapping = readMethod.getAnnotation(Mapping.class);
                String propertyName = property.getName();
                if (mapping == null) continue;
                ClassMapBuilder.validate(mapping, readMethod);
                String pairName = mapping.value();
                ClassMapBuilder.addGenericMapping(classMap, configuration, pairName, propertyName);
            }
            return false;
        }
    }

    public static class CollectionMappingGenerator
    implements ClassMappingGenerator {
        public boolean accepts(ClassMap classMap) {
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            return MappingUtils.isSupportedCollection(srcClass) && MappingUtils.isSupportedCollection(destClass);
        }

        public boolean apply(ClassMap classMap, Configuration configuration) {
            GenericFieldMap fieldMap = new GenericFieldMap(classMap);
            DozerField selfReference = new DozerField("this", null);
            fieldMap.setSrcField(selfReference);
            fieldMap.setDestField(selfReference);
            classMap.addFieldMapping(fieldMap);
            return true;
        }
    }

    public static class BeanMappingGenerator
    implements ClassMappingGenerator {
        public boolean accepts(ClassMap classMap) {
            return true;
        }

        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] destProperties;
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            for (PropertyDescriptor destPropertyDescriptor : destProperties = ReflectionUtils.getPropertyDescriptors(destClass)) {
                PropertyDescriptor srcProperty;
                String fieldName = destPropertyDescriptor.getName();
                if (ClassMapBuilder.shouldIgnoreField(fieldName, srcClass, destClass) || classMap.getFieldMapUsingDest(fieldName) != null || classMap.getFieldMapUsingSrc(fieldName) != null || destPropertyDescriptor.getWriteMethod() == null || (srcProperty = ReflectionUtils.findPropertyDescriptor(srcClass, fieldName, null)) == null || srcProperty.getReadMethod() == null) continue;
                ClassMapBuilder.addGenericMapping(classMap, configuration, fieldName, fieldName);
            }
            return false;
        }
    }

    public static class MapMappingGenerator
    implements ClassMappingGenerator {
        public boolean accepts(ClassMap classMap) {
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            return MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null || MappingUtils.isSupportedMap(destClass) || classMap.getDestClassMapGetMethod() != null;
        }

        public boolean apply(ClassMap classMap, Configuration configuration) {
            PropertyDescriptor[] properties;
            Class<?> srcClass = classMap.getSrcClassToMap();
            Class<?> destClass = classMap.getDestClassToMap();
            boolean destinationIsMap = false;
            if (MappingUtils.isSupportedMap(srcClass) || classMap.getSrcClassMapGetMethod() != null) {
                properties = ReflectionUtils.getPropertyDescriptors(destClass);
            } else {
                properties = ReflectionUtils.getPropertyDescriptors(srcClass);
                destinationIsMap = true;
            }
            for (PropertyDescriptor property : properties) {
                String fieldName = property.getName();
                if (ClassMapBuilder.shouldIgnoreField(fieldName, srcClass, destClass) || destinationIsMap && classMap.getFieldMapUsingSrc(fieldName) != null || !destinationIsMap && classMap.getFieldMapUsingDest(fieldName, true) != null) continue;
                MapFieldMap fieldMap = new MapFieldMap(classMap);
                DozerField srcField = new DozerField(MappingUtils.isSupportedMap(srcClass) ? "this" : fieldName, null);
                srcField.setKey(fieldName);
                if (StringUtils.isNotEmpty((String)classMap.getSrcClassMapGetMethod()) || StringUtils.isNotEmpty((String)classMap.getSrcClassMapSetMethod())) {
                    srcField.setMapGetMethod(classMap.getSrcClassMapGetMethod());
                    srcField.setMapSetMethod(classMap.getSrcClassMapSetMethod());
                    srcField.setName("this");
                }
                DozerField destField = new DozerField(MappingUtils.isSupportedMap(destClass) ? "this" : fieldName, null);
                srcField.setKey(fieldName);
                if (StringUtils.isNotEmpty((String)classMap.getDestClassMapGetMethod()) || StringUtils.isNotEmpty((String)classMap.getDestClassMapSetMethod())) {
                    destField.setMapGetMethod(classMap.getDestClassMapGetMethod());
                    destField.setMapSetMethod(classMap.getDestClassMapSetMethod());
                    destField.setName("this");
                }
                fieldMap.setSrcField(srcField);
                fieldMap.setDestField(destField);
                classMap.addFieldMapping(fieldMap);
            }
            return true;
        }
    }

    public static interface ClassMappingGenerator {
        public boolean accepts(ClassMap var1);

        public boolean apply(ClassMap var1, Configuration var2);
    }
}

