/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.jaxrs.CxfRsBinding;
import org.apache.camel.component.cxf.jaxrs.CxfRsConsumer;
import org.apache.camel.component.cxf.jaxrs.CxfRsHeaderFilterStrategy;
import org.apache.camel.component.cxf.jaxrs.CxfRsProducer;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsBinding;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfRsEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsEndpoint.class);
    protected Bus bus;
    private Map<String, String> parameters;
    private List<Class<?>> resourceClasses;
    private HeaderFilterStrategy headerFilterStrategy;
    private CxfRsBinding binding;
    private boolean httpClientAPI = true;
    private String address;
    private boolean throwExceptionOnFailure = true;
    private int maxClientCacheSize = 10;
    private boolean loggingFeatureEnabled;
    private int loggingSizeLimit;
    private AtomicBoolean getBusHasBeenCalled = new AtomicBoolean(false);
    private boolean isSetDefaultBus;

    @Deprecated
    public CxfRsEndpoint(String endpointUri, CamelContext camelContext) {
        super(endpointUri, camelContext);
        this.setAddress(endpointUri);
    }

    public CxfRsEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
        this.setAddress(endpointUri);
    }

    protected void updateEndpointUri(String endpointUri) {
        super.setEndpointUri(endpointUri);
    }

    public void setParameters(Map<String, String> param) {
        this.parameters = param;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setHttpClientAPI(boolean clientAPI) {
        this.httpClientAPI = clientAPI;
    }

    public boolean isHttpClientAPI() {
        return this.httpClientAPI;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CxfRsConsumer(this, processor);
    }

    public Producer createProducer() throws Exception {
        return new CxfRsProducer(this);
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBinding(CxfRsBinding binding) {
        this.binding = binding;
    }

    public CxfRsBinding getBinding() {
        return this.binding;
    }

    protected void checkBeanType(Object object, Class<?> clazz) {
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("The configure bean is not the instance of " + clazz.getName());
        }
    }

    protected void setupJAXRSServerFactoryBean(JAXRSServerFactoryBean sfb) {
        if (this.getAddress() != null) {
            sfb.setAddress(this.getAddress());
        }
        if (this.getResourceClasses() != null) {
            sfb.setResourceClasses(CastUtils.cast(this.getResourceClasses(), Class.class));
        }
        sfb.setStart(false);
    }

    protected void setupJAXRSClientFactoryBean(JAXRSClientFactoryBean cfb, String address) {
        if (address != null) {
            cfb.setAddress(address);
        }
        if (this.getResourceClasses() != null && !this.getResourceClasses().isEmpty()) {
            cfb.setResourceClass(this.getResourceClasses().get(0));
        }
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                cfb.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                cfb.getFeatures().add(new LoggingFeature());
            }
        }
        cfb.setThreadSafe(true);
    }

    protected JAXRSServerFactoryBean newJAXRSServerFactoryBean() {
        return new JAXRSServerFactoryBean();
    }

    protected JAXRSClientFactoryBean newJAXRSClientFactoryBean() {
        return new JAXRSClientFactoryBean();
    }

    protected String resolvePropertyPlaceholders(String str) {
        try {
            if (this.getCamelContext() != null) {
                return this.getCamelContext().resolvePropertyPlaceholders(str);
            }
            return str;
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
    }

    public JAXRSServerFactoryBean createJAXRSServerFactoryBean() {
        JAXRSServerFactoryBean answer = this.newJAXRSServerFactoryBean();
        this.setupJAXRSServerFactoryBean(answer);
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                answer.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                answer.getFeatures().add(new LoggingFeature());
            }
        }
        return answer;
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean() {
        return this.createJAXRSClientFactoryBean(this.getAddress());
    }

    public JAXRSClientFactoryBean createJAXRSClientFactoryBean(String address) {
        JAXRSClientFactoryBean answer = this.newJAXRSClientFactoryBean();
        this.setupJAXRSClientFactoryBean(answer, address);
        if (this.isLoggingFeatureEnabled()) {
            if (this.getLoggingSizeLimit() > 0) {
                answer.getFeatures().add(new LoggingFeature(this.getLoggingSizeLimit()));
            } else {
                answer.getFeatures().add(new LoggingFeature());
            }
        }
        return answer;
    }

    public List<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    public void addResourceClass(Class<?> resourceClass) {
        if (this.resourceClasses == null) {
            this.resourceClasses = new ArrayList();
        }
        this.resourceClasses.add(resourceClass);
    }

    public void setResourceClasses(List<Class<?>> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.resolvePropertyPlaceholders(this.address);
    }

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeatureEnabled;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        this.loggingFeatureEnabled = loggingFeatureEnabled;
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        this.loggingSizeLimit = loggingSizeLimit;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public void setMaxClientCacheSize(int maxClientCacheSize) {
        this.maxClientCacheSize = maxClientCacheSize;
    }

    public int getMaxClientCacheSize() {
        return this.maxClientCacheSize;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = CxfEndpointUtils.createBus(this.getCamelContext());
            LOG.debug("Using DefaultBus {}", (Object)this.bus);
        }
        if (!this.getBusHasBeenCalled.getAndSet(true) && this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
            LOG.debug("Set bus {} as thread default bus", (Object)this.bus);
        }
        return this.bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new CxfRsHeaderFilterStrategy();
        }
        if (this.binding == null) {
            this.binding = new DefaultCxfRsBinding();
        }
        if (this.binding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.binding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
    }

    protected void doStop() throws Exception {
    }
}

