/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Provides;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.cloudfiles.blobstore.CloudFilesAsyncBlobStore;
import org.jclouds.cloudfiles.blobstore.CloudFilesBlobStore;
import org.jclouds.cloudfiles.blobstore.functions.CloudFilesObjectToBlobMetadata;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.openstack.swift.blobstore.SwiftAsyncBlobStore;
import org.jclouds.openstack.swift.blobstore.SwiftBlobStore;
import org.jclouds.openstack.swift.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;

public class CloudFilesBlobStoreContextModule
extends SwiftBlobStoreContextModule {
    @Provides
    @Singleton
    protected LoadingCache<String, URI> cdnContainer(final CloudFilesClient client) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, URI>(){

            public URI load(String container) {
                ContainerCDNMetadata md = client.getCDNMetadata(container);
                return md != null ? md.getCDNUri() : null;
            }

            public String toString() {
                return "getCDNMetadata()";
            }
        });
    }

    protected void configure() {
        super.configure();
        this.bind(SwiftBlobStore.class).to(CloudFilesBlobStore.class);
        this.bind(SwiftAsyncBlobStore.class).to(CloudFilesAsyncBlobStore.class);
        this.bind(ObjectToBlobMetadata.class).to(CloudFilesObjectToBlobMetadata.class);
    }
}

