/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.domain;

import java.net.URI;

public class ContainerCDNMetadata
implements Comparable<ContainerCDNMetadata> {
    private String name;
    private boolean cdn_enabled;
    private long ttl;
    private URI cdn_uri;
    private String referrer_acl;
    private String useragent_acl;
    private boolean log_retention;

    public ContainerCDNMetadata(String name, boolean cdnEnabled, long ttl, URI cdnUri) {
        this.name = name;
        this.cdn_enabled = cdnEnabled;
        this.ttl = ttl;
        this.cdn_uri = cdnUri;
    }

    public ContainerCDNMetadata() {
    }

    public String getName() {
        return this.name;
    }

    public URI getCDNUri() {
        return this.cdn_uri;
    }

    public long getTTL() {
        return this.ttl;
    }

    public boolean isCDNEnabled() {
        return this.cdn_enabled;
    }

    @Override
    public int compareTo(ContainerCDNMetadata o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cdn_uri == null ? 0 : this.cdn_uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerCDNMetadata other = (ContainerCDNMetadata)obj;
        return !(this.cdn_uri == null ? other.cdn_uri != null : !this.cdn_uri.equals(other.cdn_uri));
    }

    public String getReferrerACL() {
        return this.referrer_acl;
    }

    public String getUseragentACL() {
        return this.useragent_acl;
    }

    public boolean isLogRetention() {
        return this.log_retention;
    }

    public String toString() {
        return String.format("[name=%s, cdn_uri=%s, cdn_enabled=%s, log_retention=%s, referrer_acl=%s, ttl=%s, useragent_acl=%s]", this.name, this.cdn_uri, this.cdn_enabled, this.log_retention, this.referrer_acl, this.ttl, this.useragent_acl);
    }
}

