/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListCdnContainerOptions
extends BaseHttpRequestOptions {
    public static final ListCdnContainerOptions NONE = new ListCdnContainerOptions();

    public ListCdnContainerOptions enabledOnly() {
        this.queryParameters.put((Object)"enabled_only", (Object)"true");
        return this;
    }

    public ListCdnContainerOptions afterMarker(String marker) {
        this.queryParameters.put((Object)"marker", Preconditions.checkNotNull((Object)marker, (Object)"marker"));
        return this;
    }

    public ListCdnContainerOptions maxResults(int limit) {
        Preconditions.checkState((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkState((limit <= 10000 ? 1 : 0) != 0, (Object)"limit must be <= 10000");
        this.queryParameters.put((Object)"limit", (Object)Integer.toString(limit));
        return this;
    }

    public static class Builder {
        public static ListCdnContainerOptions enabledOnly() {
            ListCdnContainerOptions options = new ListCdnContainerOptions();
            return options.enabledOnly();
        }

        public static ListCdnContainerOptions afterMarker(String marker) {
            ListCdnContainerOptions options = new ListCdnContainerOptions();
            return options.afterMarker(marker);
        }

        public static ListCdnContainerOptions maxResults(int limit) {
            ListCdnContainerOptions options = new ListCdnContainerOptions();
            return options.maxResults(limit);
        }
    }
}

