/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.transaction.impl;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTAPersistenceContextRegistry
extends ServiceTracker {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private static final TSRKey EMF_MAP_KEY = new TSRKey();
    private final AtomicReference<TransactionSynchronizationRegistry> tranRegistry = new AtomicReference();
    private AtomicReference<ServiceReference> tranRegistryRef = new AtomicReference();

    public JTAPersistenceContextRegistry(BundleContext context) {
        super(context, TransactionSynchronizationRegistry.class.getName(), null);
        this.open();
    }

    public final EntityManager getCurrentPersistenceContext(EntityManagerFactory persistenceUnit, Map<?, ?> properties, AtomicLong activeCount, DestroyCallback cbk) throws TransactionRequiredException {
        if (!this.isTransactionActive()) {
            if (this.jtaIntegrationAvailable()) {
                throw new TransactionRequiredException("No transaction currently active");
            }
            throw new TransactionRequiredException("No JTA transaction services implementation is currently available. As a result the JPA container cannot integrate with JTA transactions.");
        }
        EntityManager toReturn = null;
        TransactionSynchronizationRegistry tsr = this.tranRegistry.get();
        IdentityHashMap<EntityManagerFactory, EntityManager> contextsForTransaction = (IdentityHashMap<EntityManagerFactory, EntityManager>)tsr.getResource((Object)EMF_MAP_KEY);
        if (contextsForTransaction != null) {
            toReturn = (EntityManager)contextsForTransaction.get(persistenceUnit);
        } else {
            contextsForTransaction = new IdentityHashMap<EntityManagerFactory, EntityManager>();
            try {
                tsr.putResource((Object)EMF_MAP_KEY, contextsForTransaction);
            }
            catch (IllegalStateException e) {
                _logger.warn("Unable to create a persistence context for the transaction {} because the is not active", new Object[]{tsr.getTransactionKey()});
                throw new TransactionRequiredException("Unable to assiociate resources with transaction " + tsr.getTransactionKey());
            }
        }
        if (toReturn == null) {
            EntityManager entityManager = toReturn = properties == null ? persistenceUnit.createEntityManager() : persistenceUnit.createEntityManager(properties);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Created a new persistence context {} for transaction {}.", new Object[]{toReturn, tsr.getTransactionKey()});
            }
            try {
                tsr.registerInterposedSynchronization((Synchronization)new EntityManagerClearUp(toReturn, activeCount, cbk));
            }
            catch (IllegalStateException e) {
                _logger.warn("No persistence context could be created as the JPA container could not register a synchronization with the transaction {}.", new Object[]{tsr.getTransactionKey()});
                toReturn.close();
                throw new TransactionRequiredException("Unable to synchronize with transaction " + tsr.getTransactionKey());
            }
            contextsForTransaction.put(persistenceUnit, toReturn);
            activeCount.incrementAndGet();
        } else if (_logger.isDebugEnabled()) {
            _logger.debug("Re-using a persistence context for transaction " + tsr.getTransactionKey());
        }
        return toReturn;
    }

    public final boolean isTransactionActive() {
        TransactionSynchronizationRegistry tsr = this.tranRegistry.get();
        return tsr != null && tsr.getTransactionKey() != null;
    }

    public final boolean jtaIntegrationAvailable() {
        return this.tranRegistry.get() != null;
    }

    public final Object addingService(ServiceReference ref) {
        if (this.tranRegistryRef.compareAndSet(null, ref)) {
            TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)this.context.getService(ref);
            if (tsr != null) {
                if (this.tranRegistry.compareAndSet(null, tsr)) {
                    _logger.info("A TransactionSynchronizationRegistry service is now available in the runtime. Managed persistence contexts will nowintegrate with JTA transactions using {}.", new Object[]{ref});
                } else {
                    this.tranRegistry.set(tsr);
                    _logger.warn("The TransactionSynchronizationRegistry used to manage persistence contexts has been replaced. The new TransactionSynchronizationRegistry, {}, will now be used to manage persistence contexts. Managed persistence contexts may not work correctly unless the runtime uses the new JTA Transaction services implementation to manage transactions.", new Object[]{ref});
                }
            } else {
                this.tranRegistryRef.compareAndSet(ref, null);
            }
        }
        return ref;
    }

    public final void removedService(ServiceReference reference, Object o) {
        if (this.tranRegistryRef.get() == reference) {
            ServiceReference[] refs = this.getServiceReferences();
            ServiceReference chosenRef = null;
            TransactionSynchronizationRegistry replacement = null;
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    if (ref == reference || (replacement = (TransactionSynchronizationRegistry)this.context.getService(ref)) == null) continue;
                    chosenRef = ref;
                    break;
                }
            }
            if (replacement == null) {
                TransactionSynchronizationRegistry old = this.tranRegistry.get();
                this.tranRegistryRef.set(null);
                this.tranRegistry.compareAndSet(old, null);
                _logger.warn("The TransactionSynchronizationRegistry used to manage persistence contexts is no longer available. Managed persistence contexts will no longer be able to integrate with JTA transactions, and will behave as if no there is no transaction context at all times until a new TransactionSynchronizationRegistry is available. Applications using managed persistence contexts may not work correctly until a new JTA Transaction services implementation is available.");
            } else {
                this.tranRegistryRef.set(chosenRef);
                this.tranRegistry.set(replacement);
                _logger.warn("The TransactionSynchronizationRegistry used to manage persistence contexts has been replaced. The new TransactionSynchronizationRegistry, {}, will now be used to manage persistence contexts. Managed persistence contexts may not work correctly unless the runtime uses the new JTA Transaction services implementation to manage transactions.", new Object[]{chosenRef});
            }
            this.context.ungetService(reference);
            if (replacement == null) {
                ServiceReference[] retryRefs = this.getServiceReferences();
                if (refs != null) {
                    for (ServiceReference r : retryRefs) {
                        if (r == reference) continue;
                        this.addingService(r);
                        if (this.tranRegistryRef.get() != null) break;
                    }
                }
            }
        }
    }

    private static final class EntityManagerClearUp
    implements Synchronization {
        private final EntityManager context;
        private final AtomicLong activeCount;
        private final DestroyCallback callback;

        public EntityManagerClearUp(EntityManager em, AtomicLong instanceCount, DestroyCallback cbk) {
            this.context = em;
            this.activeCount = instanceCount;
            this.callback = cbk;
        }

        public final void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void afterCompletion(int arg0) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Clearing up EntityManager {} as the transaction has completed.", new Object[]{this.context});
            }
            try {
                this.activeCount.decrementAndGet();
                this.callback.callback();
            }
            finally {
                try {
                    this.context.close();
                }
                catch (Exception e) {
                    _logger.warn("There was an error when the container closed an EntityManager", (Object)this.context);
                }
            }
        }
    }

    private static final class TSRKey {
        private TSRKey() {
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final int hashCode() {
            return -559038737;
        }
    }
}

