/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.filesystem.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.utils.filesystem.impl.ZipFileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDirectory
extends ZipFileImpl
implements IDirectory {
    private ZipDirectory root;

    public ZipDirectory(File zip1, ZipEntry entry1, ZipDirectory parent) {
        super(zip1, entry1, parent);
    }

    public ZipDirectory(File file, File fs) throws MalformedURLException {
        super(file, fs);
        this.root = this;
    }

    public IFile getFile(String name) {
        ZipFileImpl result = null;
        String entryName = this.isRoot() ? name : this.getName() + "/" + name;
        ZipEntry entryFile = this.getEntry(entryName);
        if (entryFile != null) {
            result = !entryFile.isDirectory() ? new ZipFileImpl(this.zip, entryFile, this.buildParent(entryFile)) : new ZipDirectory(this.zip, entryFile, this.buildParent(entryFile));
        }
        return result;
    }

    private ZipDirectory buildParent(ZipEntry foundEntry) {
        ZipDirectory result = this;
        String name = foundEntry.getName();
        name = name.substring(this.getName().length());
        String[] paths = name.split("/");
        StringBuilder baseBuilderCrapThingToGetRoundFindBugs = new StringBuilder(this.getName());
        if (!this.isRoot()) {
            baseBuilderCrapThingToGetRoundFindBugs.append('/');
        }
        if (paths != null && paths.length > 1) {
            for (int i = 0; i < paths.length - 1; ++i) {
                String path = paths[i];
                baseBuilderCrapThingToGetRoundFindBugs.append(path);
                ZipEntry dirEntry = this.getEntry(baseBuilderCrapThingToGetRoundFindBugs.toString());
                if (dirEntry == null) {
                    result = this;
                    break;
                }
                result = new ZipDirectory(this.zip, dirEntry, result);
                baseBuilderCrapThingToGetRoundFindBugs.append('/');
            }
        }
        return result;
    }

    public boolean isRoot() {
        boolean result = this.root == this;
        return result;
    }

    public List<IFile> listFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        ZipFile z = this.openZipFile();
        Enumeration<? extends ZipEntry> entries = z.entries();
        while (entries.hasMoreElements()) {
            ZipEntry possibleEntry = entries.nextElement();
            if (!this.isInDir(possibleEntry)) continue;
            if (possibleEntry.isDirectory()) {
                files.add(new ZipDirectory(this.zip, possibleEntry, this));
                continue;
            }
            files.add(new ZipFileImpl(this.zip, possibleEntry, this));
        }
        this.closeZipFile(z);
        return files;
    }

    public List<IFile> listAllFiles() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        ZipFile z = this.openZipFile();
        Enumeration<? extends ZipEntry> entries = z.entries();
        while (entries.hasMoreElements()) {
            ZipEntry possibleEntry = entries.nextElement();
            if (possibleEntry.isDirectory()) {
                files.add(new ZipDirectory(this.zip, possibleEntry, this));
                continue;
            }
            files.add(new ZipFileImpl(this.zip, possibleEntry, this));
        }
        this.closeZipFile(z);
        return files;
    }

    private boolean isInDir(ZipEntry possibleEntry) {
        String name = possibleEntry.getName();
        String parentDir = this.getName();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        boolean result = name.startsWith(parentDir) && !name.equals(parentDir) && name.substring(parentDir.length() + 1).indexOf(47) == -1;
        return result;
    }

    public Iterator<IFile> iterator() {
        Iterator<IFile> result = this.listFiles().iterator();
        return result;
    }

    @Override
    public IDirectory convert() {
        return this;
    }

    @Override
    public IDirectory getParent() {
        IDirectory result = this.isRoot() ? null : super.getParent();
        return result;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public InputStream open() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDirectory getRoot() {
        return this.root;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private ZipEntry getEntry(String entryName) {
        ZipFile z = this.openZipFile();
        ZipEntry entryFile = null;
        if (z != null) {
            entryFile = z.getEntry(entryName);
            this.closeZipFile(z);
        }
        return entryFile;
    }
}

