/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.OptimizationFailure;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.BlankLiteral;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableAccessorSafe;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.integration.ResolverTools;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ClassImportResolverFactory;
import org.mvel2.math.MathProcessor;
import org.mvel2.util.StringAppender;

public class ParseTools {
    public static final String[] EMPTY_STR_ARR = new String[0];
    public static final Object[] EMPTY_OBJ_ARR = new Object[0];
    public static final Class[] EMPTY_CLS_ARR = new Class[0];
    private static Map<String, Map<Integer, WeakReference<Method>>> RESOLVED_METH_CACHE;
    private static Map<Class, Map<Integer, WeakReference<Constructor>>> RESOLVED_CONST_CACHE;
    private static Map<Constructor, WeakReference<Class[]>> CONSTRUCTOR_PARMS_CACHE;
    private static Map<ClassLoader, Map<String, WeakReference<Class>>> CLASS_RESOLVER_CACHE;
    private static Map<Class, WeakReference<Constructor[]>> CLASS_CONSTRUCTOR_CACHE;
    private static final HashMap<Class, Integer> typeResolveMap;

    public static String[] parseMethodOrConstructor(char[] parm) {
        int start = -1;
        for (int i = 0; i < parm.length; ++i) {
            if (parm[i] != '(') continue;
            start = ++i;
            break;
        }
        if (start != -1) {
            return ParseTools.parseParameterList(parm, --start + 1, ParseTools.balancedCapture(parm, start, '(') - start - 1);
        }
        return EMPTY_STR_ARR;
    }

    public static String[] parseParameterDefList(char[] parm, int offset, int length) {
        String s;
        int i;
        LinkedList<String> list = new LinkedList<String>();
        if (length == -1) {
            length = parm.length;
        }
        int start = offset;
        int end = i + length;
        block6: for (i = offset; i < end; ++i) {
            switch (parm[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(parm, i, parm[i]);
                    continue block6;
                }
                case '\'': {
                    i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                    continue block6;
                }
                case '\"': {
                    i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                    continue block6;
                }
                case ',': {
                    if (i > start) {
                        while (ParseTools.isWhitespace(parm[start])) {
                            ++start;
                        }
                        s = new String(parm, start, i - start);
                        ParseTools.checkNameSafety(s);
                        list.add(s);
                    }
                    while (ParseTools.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                    continue block6;
                }
                default: {
                    if (ParseTools.isWhitespace(parm[i]) || ParseTools.isIdentifierPart(parm[i])) continue block6;
                    throw new CompileException("expected parameter");
                }
            }
        }
        if (start < length + offset && i > start) {
            s = ParseTools.createStringTrimmed(parm, start, i - start);
            if (s.length() > 0) {
                ParseTools.checkNameSafety(s);
                list.add(s);
            }
        } else if (list.size() == 0 && (s = ParseTools.createStringTrimmed(parm, start, length)).length() > 0) {
            ParseTools.checkNameSafety(s);
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] parseParameterList(char[] parm, int offset, int length) {
        String s;
        int i;
        LinkedList<String> list = new LinkedList<String>();
        if (length == -1) {
            length = parm.length;
        }
        int start = offset;
        int end = i + length;
        block6: for (i = offset; i < end; ++i) {
            switch (parm[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(parm, i, parm[i]);
                    continue block6;
                }
                case '\'': {
                    i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                    continue block6;
                }
                case '\"': {
                    i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                    continue block6;
                }
                case ',': {
                    if (i > start) {
                        while (ParseTools.isWhitespace(parm[start])) {
                            ++start;
                        }
                        list.add(new String(parm, start, i - start));
                    }
                    while (ParseTools.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                }
            }
        }
        if (start < length + offset && i > start) {
            String s2 = ParseTools.createStringTrimmed(parm, start, i - start);
            if (s2.length() > 0) {
                list.add(s2);
            }
        } else if (list.size() == 0 && (s = ParseTools.createStringTrimmed(parm, start, length)).length() > 0) {
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static Method getBestCandidate(Object[] arguments, String method, Class decl, Method[] methods, boolean requireExact) {
        Class[] targetParms = new Class[arguments.length];
        for (int i = 0; i != arguments.length; ++i) {
            targetParms[i] = arguments[i] != null ? arguments[i].getClass() : null;
        }
        return ParseTools.getBestCandidate(targetParms, method, decl, methods, requireExact);
    }

    public static Method getBestCandidate(Class[] arguments, String method, Class decl, Method[] methods, boolean requireExact) {
        WeakReference<Method> ref;
        if (methods.length == 0) {
            return null;
        }
        Method bestCandidate = null;
        int bestScore = 0;
        int score = 0;
        Integer hash = ParseTools.createClassSignatureHash(decl, arguments);
        Map<Integer, WeakReference<Method>> methCache = RESOLVED_METH_CACHE.get(method);
        if (methCache != null && (ref = methCache.get(hash)) != null && (bestCandidate = (Method)ref.get()) != null) {
            return bestCandidate;
        }
        for (Method meth : methods) {
            Class<?>[] parmTypes;
            if (!method.equals(meth.getName()) || (parmTypes = meth.getParameterTypes()).length != arguments.length) continue;
            if (arguments.length == 0 && parmTypes.length == 0) {
                bestCandidate = meth;
                break;
            }
            for (int i = 0; i != arguments.length; ++i) {
                if (arguments[i] == null) {
                    if (!parmTypes[i].isPrimitive()) {
                        score += 5;
                        continue;
                    }
                    score = 0;
                    break;
                }
                if (parmTypes[i] == arguments[i]) {
                    score += 6;
                    continue;
                }
                if (parmTypes[i].isPrimitive() && ParseTools.boxPrimitive(parmTypes[i]) == arguments[i]) {
                    score += 5;
                    continue;
                }
                if (arguments[i].isPrimitive() && ParseTools.unboxPrimitive(arguments[i]) == parmTypes[i]) {
                    score += 5;
                    continue;
                }
                if (ParseTools.isNumericallyCoercible(arguments[i], parmTypes[i])) {
                    score += 4;
                    continue;
                }
                if (ParseTools.boxPrimitive(parmTypes[i]).isAssignableFrom(ParseTools.boxPrimitive(arguments[i])) && Object.class != arguments[i]) {
                    score += 3 + ParseTools.scoreInterface(parmTypes[i], arguments[i]);
                    continue;
                }
                if (!requireExact && DataConversion.canConvert(parmTypes[i], arguments[i])) {
                    if (parmTypes[i].isArray() && arguments[i].isArray()) {
                        ++score;
                    } else if (parmTypes[i] == Character.TYPE && arguments[i] == String.class) {
                        ++score;
                    }
                    ++score;
                    continue;
                }
                if (arguments[i] == Object.class) {
                    ++score;
                    continue;
                }
                score = 0;
                break;
            }
            if (score != 0 && score > bestScore) {
                bestCandidate = meth;
                bestScore = score;
            }
            score = 0;
        }
        if (bestCandidate != null) {
            if (methCache == null) {
                methCache = new WeakHashMap<Integer, WeakReference<Method>>();
                RESOLVED_METH_CACHE.put(method, methCache);
            }
            methCache.put(hash, new WeakReference<Method>(bestCandidate));
        }
        return bestCandidate;
    }

    public static int scoreInterface(Class parm, Class arg) {
        Class<?>[] iface;
        if (parm.isInterface() && (iface = arg.getInterfaces()) != null) {
            for (Class<?> c : iface) {
                if (c == parm) {
                    return 1;
                }
                if (!parm.isAssignableFrom(c)) continue;
                return ParseTools.scoreInterface(parm, arg.getSuperclass());
            }
        }
        return 0;
    }

    public static Method getExactMatch(String name, Class[] args, Class returnType, Class cls) {
        for (Method meth : cls.getMethods()) {
            Class<?>[] parameterTypes;
            if (!name.equals(meth.getName()) || returnType != meth.getReturnType() || (parameterTypes = meth.getParameterTypes()).length != args.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] == args[i]) continue;
                return null;
            }
            return meth;
        }
        return null;
    }

    public static Method getWidenedTarget(Method method) {
        Class<?> cls = method.getDeclaringClass();
        Method m = method;
        Method best = method;
        Class[] args = method.getParameterTypes();
        String name = method.getName();
        Class<?> rt = m.getReturnType();
        do {
            if (cls.getInterfaces().length != 0) {
                for (Class<?> iface : cls.getInterfaces()) {
                    m = ParseTools.getExactMatch(name, args, rt, iface);
                    if (m == null || (best = m).getDeclaringClass().getSuperclass() == null) continue;
                    cls = m.getDeclaringClass();
                }
            }
            if (cls == method.getDeclaringClass() || (m = ParseTools.getExactMatch(name, args, rt, cls)) == null || (best = m).getDeclaringClass().getSuperclass() == null) continue;
            cls = m.getDeclaringClass();
        } while ((cls = cls.getSuperclass()) != null);
        return best;
    }

    private static Class[] getConstructors(Constructor cns) {
        Class[] parms;
        WeakReference<Class[]> ref = CONSTRUCTOR_PARMS_CACHE.get(cns);
        if (ref != null && (parms = (Class[])ref.get()) != null) {
            return parms;
        }
        parms = cns.getParameterTypes();
        CONSTRUCTOR_PARMS_CACHE.put(cns, new WeakReference<Class<?>[]>(parms));
        return parms;
    }

    public static Constructor getBestConstructorCandidate(Object[] args, Class cls, boolean requireExact) {
        Class[] arguments = new Class[args.length];
        for (int i = 0; i != args.length; ++i) {
            if (args[i] == null) continue;
            arguments[i] = args[i].getClass();
        }
        return ParseTools.getBestConstructorCandidate(arguments, cls, requireExact);
    }

    public static Constructor getBestConstructorCandidate(Class[] arguments, Class cls, boolean requireExact) {
        WeakReference<Constructor> ref;
        Constructor bestCandidate = null;
        int bestScore = 0;
        int score = 0;
        Integer hash = ParseTools.createClassSignatureHash(cls, arguments);
        Map<Integer, WeakReference<Constructor>> cache = RESOLVED_CONST_CACHE.get(cls);
        if (cache != null && (ref = cache.get(hash)) != null && (bestCandidate = (Constructor)ref.get()) != null) {
            return bestCandidate;
        }
        for (Constructor construct : ParseTools.getConstructors(cls)) {
            Class[] parmTypes = ParseTools.getConstructors(construct);
            if (parmTypes.length != arguments.length) continue;
            if (arguments.length == 0 && parmTypes.length == 0) {
                return construct;
            }
            for (int i = 0; i != arguments.length; ++i) {
                if (arguments[i] == null) {
                    if (!parmTypes[i].isPrimitive()) {
                        score += 5;
                        continue;
                    }
                    score = 0;
                    break;
                }
                if (parmTypes[i] == arguments[i]) {
                    score += 6;
                    continue;
                }
                if (parmTypes[i].isPrimitive() && ParseTools.boxPrimitive(parmTypes[i]) == arguments[i]) {
                    score += 5;
                    continue;
                }
                if (arguments[i].isPrimitive() && ParseTools.unboxPrimitive(arguments[i]) == parmTypes[i]) {
                    score += 5;
                    continue;
                }
                if (ParseTools.isNumericallyCoercible(arguments[i], parmTypes[i])) {
                    score += 4;
                    continue;
                }
                if (ParseTools.boxPrimitive(parmTypes[i]).isAssignableFrom(ParseTools.boxPrimitive(arguments[i])) && parmTypes[i] != Object.class) {
                    score += 3 + ParseTools.scoreInterface(parmTypes[i], arguments[i]);
                    continue;
                }
                if (!requireExact && DataConversion.canConvert(parmTypes[i], arguments[i])) {
                    if (parmTypes[i].isArray() && arguments[i].isArray()) {
                        ++score;
                    } else if (parmTypes[i] == Character.TYPE && arguments[i] == String.class) {
                        ++score;
                    }
                    ++score;
                    continue;
                }
                if (arguments[i] == Object.class) {
                    ++score;
                    continue;
                }
                score = 0;
                break;
            }
            if (score != 0 && score > bestScore) {
                bestCandidate = construct;
                bestScore = score;
            }
            score = 0;
        }
        if (bestCandidate != null) {
            if (cache == null) {
                cache = new WeakHashMap<Integer, WeakReference<Constructor>>();
                RESOLVED_CONST_CACHE.put(cls, cache);
            }
            cache.put(hash, new WeakReference<Constructor>(bestCandidate));
        }
        return bestCandidate;
    }

    public static Class createClass(String className, ParserContext pCtx) throws ClassNotFoundException {
        Class<?> cls;
        WeakReference<Class> ref;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map<String, WeakReference<Class>> cache = CLASS_RESOLVER_CACHE.get(classLoader);
        if (cache == null) {
            cache = new WeakHashMap<String, WeakReference<Class>>(10);
            CLASS_RESOLVER_CACHE.put(classLoader, cache);
        }
        if ((ref = cache.get(className)) != null && (cls = (Class<?>)ref.get()) != null) {
            return cls;
        }
        try {
            cls = pCtx == null ? Class.forName(className, true, Thread.currentThread().getContextClassLoader()) : Class.forName(className, true, pCtx.getParserConfiguration().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            cls = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        cache.put(className, new WeakReference(cls));
        return cls;
    }

    public static Constructor[] getConstructors(Class cls) {
        Constructor[] cns;
        WeakReference<Constructor[]> ref = CLASS_CONSTRUCTOR_CACHE.get(cls);
        if (ref != null && (cns = (Constructor[])ref.get()) != null) {
            return cns;
        }
        cns = cls.getConstructors();
        CLASS_CONSTRUCTOR_CACHE.put(cls, new WeakReference<Constructor<?>[]>(cns));
        return cns;
    }

    public static String[] captureContructorAndResidual(char[] cs) {
        int depth = 0;
        block4: for (int i = 0; i < cs.length; ++i) {
            switch (cs[i]) {
                case '(': {
                    ++depth;
                    continue block4;
                }
                case ')': {
                    if (1 != depth--) continue block4;
                    return new String[]{new String(cs, 0, ++i), ParseTools.createStringTrimmed(cs, i, cs.length - i)};
                }
            }
        }
        return new String[]{new String(cs)};
    }

    public static Class boxPrimitive(Class cls) {
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.class;
        }
        if (cls == int[].class || cls == Integer[].class) {
            return Integer[].class;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Character.class;
        }
        if (cls == char[].class || cls == Character[].class) {
            return Character[].class;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.class;
        }
        if (cls == long[].class || cls == Long[].class) {
            return Long[].class;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.class;
        }
        if (cls == short[].class || cls == Short[].class) {
            return Short[].class;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.class;
        }
        if (cls == double[].class || cls == Double[].class) {
            return Double[].class;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.class;
        }
        if (cls == float[].class || cls == Float[].class) {
            return Float[].class;
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == boolean[].class || cls == Boolean[].class) {
            return Boolean[].class;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.class;
        }
        if (cls == byte[].class || cls == Byte[].class) {
            return Byte[].class;
        }
        return cls;
    }

    public static Class unboxPrimitive(Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (cls == Integer[].class || cls == int[].class) {
            return int[].class;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.TYPE;
        }
        if (cls == Long[].class || cls == long[].class) {
            return long[].class;
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.TYPE;
        }
        if (cls == Character[].class || cls == char[].class) {
            return char[].class;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.TYPE;
        }
        if (cls == Short[].class || cls == short[].class) {
            return short[].class;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.TYPE;
        }
        if (cls == Double[].class || cls == double[].class) {
            return double[].class;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.TYPE;
        }
        if (cls == Float[].class || cls == float[].class) {
            return float[].class;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (cls == Boolean[].class || cls == boolean[].class) {
            return boolean[].class;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (cls == Byte[].class || cls == byte[].class) {
            return byte[].class;
        }
        return cls;
    }

    public static boolean containsCheck(Object compareTo, Object compareTest) {
        if (compareTo == null) {
            return false;
        }
        if (compareTo instanceof String) {
            return ((String)compareTo).contains(String.valueOf(compareTest));
        }
        if (compareTo instanceof Collection) {
            return ((Collection)compareTo).contains(compareTest);
        }
        if (compareTo instanceof Map) {
            return ((Map)compareTo).containsKey(compareTest);
        }
        if (compareTo.getClass().isArray()) {
            for (Object o : (Object[])compareTo) {
                if (compareTest == null && o == null) {
                    return true;
                }
                if (!((Boolean)MathProcessor.doOperations(o, 18, compareTest)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static int createClassSignatureHash(Class declaring, Class[] sig) {
        int hash = 0;
        for (Class cls : sig) {
            if (cls == null) continue;
            hash += cls.hashCode();
        }
        return hash + sig.length + declaring.hashCode();
    }

    public static int handleEscapeSequence(char[] escapeStr, int pos) {
        escapeStr[pos - 1] = '\u0000';
        switch (escapeStr[pos]) {
            case '\\': {
                escapeStr[pos] = 92;
                return 1;
            }
            case 'b': {
                escapeStr[pos] = 8;
                return 1;
            }
            case 'f': {
                escapeStr[pos] = 12;
                return 1;
            }
            case 't': {
                escapeStr[pos] = 9;
                return 1;
            }
            case 'r': {
                escapeStr[pos] = 13;
                return 1;
            }
            case 'n': {
                escapeStr[pos] = 10;
                return 1;
            }
            case '\'': {
                escapeStr[pos] = 39;
                return 1;
            }
            case '\"': {
                escapeStr[pos] = 34;
                return 1;
            }
            case 'u': {
                int s = pos;
                if (s + 4 > escapeStr.length) {
                    throw new CompileException("illegal unicode escape sequence");
                }
                while (++pos - s != 5) {
                    if (escapeStr[pos] > '/' && escapeStr[pos] < ':' || escapeStr[pos] > '@' && escapeStr[pos] < 'G') continue;
                    throw new CompileException("illegal unicode escape sequence");
                }
                escapeStr[s - 1] = (char)Integer.decode("0x" + new String(escapeStr, s + 1, 4)).intValue();
                escapeStr[s] = '\u0000';
                escapeStr[s + 1] = '\u0000';
                escapeStr[s + 2] = '\u0000';
                escapeStr[s + 3] = '\u0000';
                escapeStr[s + 4] = '\u0000';
                return 5;
            }
        }
        int s = pos;
        while (escapeStr[pos] >= '0' && escapeStr[pos] < '8') {
            if (pos != s && escapeStr[s] > '3') {
                escapeStr[s - 1] = (char)Integer.decode("0" + new String(escapeStr, s, pos - s + 1)).intValue();
                escapeStr[s] = '\u0000';
                escapeStr[s + 1] = '\u0000';
                return 2;
            }
            if (pos - s == 2) {
                escapeStr[s - 1] = (char)Integer.decode("0" + new String(escapeStr, s, pos - s + 1)).intValue();
                escapeStr[s] = '\u0000';
                escapeStr[s + 1] = '\u0000';
                escapeStr[s + 2] = '\u0000';
                return 3;
            }
            if (pos + 1 == escapeStr.length || escapeStr[pos] < '0' || escapeStr[pos] > '7') {
                escapeStr[s - 1] = (char)Integer.decode("0" + new String(escapeStr, s, pos - s + 1)).intValue();
                escapeStr[s] = '\u0000';
                return 1;
            }
            ++pos;
        }
        throw new CompileException("illegal escape sequence: " + escapeStr[pos]);
    }

    public static char[] createShortFormOperativeAssignment(String name, char[] statement, int operation) {
        if (operation == -1) {
            return statement;
        }
        int op = 0;
        switch (operation) {
            case 0: {
                op = 43;
                break;
            }
            case 20: {
                op = 35;
                break;
            }
            case 1: {
                op = 45;
                break;
            }
            case 2: {
                op = 42;
                break;
            }
            case 4: {
                op = 37;
                break;
            }
            case 3: {
                op = 47;
                break;
            }
            case 6: {
                op = 38;
                break;
            }
            case 7: {
                op = 124;
                break;
            }
            case 10: {
                op = 171;
                break;
            }
            case 9: {
                op = 187;
                break;
            }
            case 11: {
                op = 172;
            }
        }
        char[] stmt = new char[name.length() + statement.length + 1];
        System.arraycopy(name.toCharArray(), 0, stmt, 0, name.length());
        stmt[name.length()] = op;
        System.arraycopy(statement, 0, stmt, name.length() + 1, statement.length);
        return stmt;
    }

    public static ClassImportResolverFactory findClassImportResolverFactory(VariableResolverFactory factory) {
        for (VariableResolverFactory v = factory; v != null; v = v.getNextFactory()) {
            if (!(v instanceof ClassImportResolverFactory)) continue;
            return (ClassImportResolverFactory)v;
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        return ResolverTools.insertFactory(factory, new ClassImportResolverFactory());
    }

    public static Class findClass(VariableResolverFactory factory, String name, ParserContext ctx) throws ClassNotFoundException {
        try {
            if (AbstractParser.LITERALS.containsKey(name)) {
                return (Class)AbstractParser.LITERALS.get(name);
            }
            if (factory != null && factory.isResolveable(name)) {
                return (Class)factory.getVariableResolver(name).getValue();
            }
            if (ctx != null && ctx.hasImport(name)) {
                return ctx.getImport(name);
            }
            return ParseTools.createClass(name, ctx);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException("class not found: " + name, e);
        }
    }

    public static char[] subset(char[] array, int start, int length) {
        if (length < 0) {
            return new char[0];
        }
        char[] newArray = new char[length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = array[i + start];
        }
        return newArray;
    }

    public static char[] subset(char[] array, int start) {
        char[] newArray = new char[array.length - start];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = array[i + start];
        }
        return newArray;
    }

    public static int resolveType(Object o) {
        if (o == null) {
            return 0;
        }
        return ParseTools.__resolveType(o.getClass());
    }

    public static int resolveType(Class cls) {
        Integer i = typeResolveMap.get(cls);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public static int __resolveType(Class cls) {
        if (Integer.class == cls) {
            return 106;
        }
        if (Double.class == cls) {
            return 109;
        }
        if (Boolean.class == cls) {
            return 15;
        }
        if (String.class == cls) {
            return 1;
        }
        if (Long.class == cls) {
            return 107;
        }
        if (Short.class == cls) {
            return 105;
        }
        if (Float.class == cls) {
            return 108;
        }
        if (Byte.class == cls) {
            return 113;
        }
        if (Character.class == cls) {
            return 112;
        }
        if (BigDecimal.class == cls) {
            return 110;
        }
        if (BigInteger.class == cls) {
            return 111;
        }
        if (Integer.TYPE == cls) {
            return 101;
        }
        if (Short.TYPE == cls) {
            return 100;
        }
        if (Float.TYPE == cls) {
            return 104;
        }
        if (Double.TYPE == cls) {
            return 103;
        }
        if (Long.TYPE == cls) {
            return 102;
        }
        if (Boolean.TYPE == cls) {
            return 7;
        }
        if (Byte.TYPE == cls) {
            return 9;
        }
        if (Character.TYPE == cls) {
            return 8;
        }
        if (BlankLiteral.class == cls) {
            return 200;
        }
        return 0;
    }

    public static boolean isNumericallyCoercible(Class target, Class parm) {
        Class boxedTarget;
        Class clazz = boxedTarget = target.isPrimitive() ? ParseTools.boxPrimitive(target) : target;
        if (boxedTarget != null && Number.class.isAssignableFrom(target) && (boxedTarget = parm.isPrimitive() ? ParseTools.boxPrimitive(parm) : parm) != null) {
            return Number.class.isAssignableFrom(boxedTarget);
        }
        return false;
    }

    public static Object narrowType(BigDecimal result, int returnTarget) {
        if (returnTarget == 109 || result.scale() > 0) {
            return result.doubleValue();
        }
        if (returnTarget == 107 || result.longValue() > Integer.MAX_VALUE) {
            return result.longValue();
        }
        return result.intValue();
    }

    public static Method determineActualTargetMethod(Method method) {
        String name = method.getName();
        for (Class<?> cls : method.getDeclaringClass().getInterfaces()) {
            for (Method meth : cls.getMethods()) {
                if (meth.getParameterTypes().length != 0 || !name.equals(meth.getName())) continue;
                return meth;
            }
        }
        return null;
    }

    public static int captureToNextTokenJunction(char[] expr, int cursor, ParserContext pCtx) {
        block4: while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '(': 
                case '{': {
                    return cursor;
                }
                case '[': {
                    cursor = ParseTools.balancedCaptureWithLineAccounting(expr, cursor, '[', pCtx) + 1;
                    continue block4;
                }
            }
            if (ParseTools.isWhitespace(expr[cursor])) {
                return cursor;
            }
            ++cursor;
        }
        return cursor;
    }

    public static int nextNonBlank(char[] expr, int cursor) {
        int i;
        if (cursor + 1 >= expr.length) {
            throw new CompileException("unexpected end of statement", expr, cursor);
        }
        for (i = cursor; i != expr.length && ParseTools.isWhitespace(expr[i]); ++i) {
        }
        return i;
    }

    public static int skipWhitespace(char[] expr, int cursor, ParserContext pCtx) {
        int line = pCtx.getLineCount();
        int lastLineStart = pCtx.getLineOffset();
        block9: while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '\n': {
                    ++line;
                    lastLineStart = cursor;
                }
                case '\r': {
                    ++cursor;
                    continue block9;
                }
                case '/': {
                    if (cursor + 1 != expr.length) {
                        switch (expr[cursor + 1]) {
                            case '/': {
                                expr[cursor++] = 32;
                                while (cursor != expr.length && expr[cursor] != '\n') {
                                    expr[cursor++] = 32;
                                }
                                if (cursor != expr.length) {
                                    expr[cursor++] = 32;
                                }
                                ++line;
                                lastLineStart = cursor;
                                continue block9;
                            }
                            case '*': {
                                int len = expr.length - 1;
                                expr[cursor++] = 32;
                                while (cursor != len && (expr[cursor] != '*' || expr[cursor + 1] != '/')) {
                                    if (expr[cursor] == '\n') {
                                        ++line;
                                        lastLineStart = cursor;
                                    }
                                    expr[cursor++] = 32;
                                }
                                if (cursor == len) continue block9;
                                int n = cursor++;
                                expr[cursor++] = 32;
                                expr[n] = 32;
                                continue block9;
                            }
                        }
                        break block9;
                    }
                }
                default: {
                    if (!ParseTools.isWhitespace(expr[cursor])) break block9;
                    ++cursor;
                    continue block9;
                }
            }
        }
        return cursor;
    }

    public static boolean isStatementNotManuallyTerminated(char[] expr, int cursor) {
        int c;
        if (cursor >= expr.length) {
            return false;
        }
        for (c = cursor; c != expr.length && ParseTools.isWhitespace(expr[c]); ++c) {
        }
        return c == expr.length || expr[c] != ';';
    }

    public static int captureToEOS(char[] expr, int cursor, ParserContext pCtx) {
        while (cursor != expr.length) {
            switch (expr[cursor]) {
                case '(': 
                case '[': 
                case '{': {
                    cursor = ParseTools.balancedCaptureWithLineAccounting(expr, cursor, expr[cursor], pCtx);
                    if (cursor < expr.length) break;
                    return cursor;
                }
                case '\"': 
                case '\'': {
                    cursor = ParseTools.captureStringLiteral(expr[cursor], expr, cursor, expr.length);
                    break;
                }
                case ',': 
                case ';': 
                case '}': {
                    return cursor;
                }
            }
            ++cursor;
        }
        return cursor;
    }

    public static int trimLeft(char[] expr, int start, int pos) {
        if (pos > expr.length) {
            pos = expr.length;
        }
        while (pos != 0 && pos >= start && ParseTools.isWhitespace(expr[pos - 1])) {
            --pos;
        }
        return pos;
    }

    public static int trimRight(char[] expr, int start, int pos) {
        while (pos != expr.length && ParseTools.isWhitespace(expr[pos])) {
            ++pos;
        }
        return pos;
    }

    public static char[] subArray(char[] expr, int start, int end) {
        if (start >= end) {
            return new char[0];
        }
        char[] newA = new char[end - start];
        for (int i = 0; i != newA.length; ++i) {
            newA[i] = expr[i + start];
        }
        return newA;
    }

    public static int balancedCapture(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < chars.length) {
                if (start < chars.length && chars[start] == '/') {
                    if (start + 1 == chars.length) {
                        return start;
                    }
                    if (chars[start + 1] == '/') {
                        ++start;
                        while (start < chars.length && chars[start] != '\n') {
                            ++start;
                        }
                    } else if (chars[start + 1] == '*') {
                        start += 2;
                        while (start < chars.length) {
                            switch (chars[start]) {
                                case '*': {
                                    if (start + 1 >= chars.length || chars[start + 1] != '/') break;
                                    break;
                                }
                            }
                            ++start;
                        }
                    }
                }
                if (start == chars.length) {
                    return start;
                }
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = ParseTools.captureStringLiteral(chars[start], chars, start, chars.length);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars, start);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars, start);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars, start);
            }
        }
        throw new CompileException("unterminated string literal", chars, start);
    }

    public static int balancedCaptureWithLineAccounting(char[] chars, int start, char type, ParserContext pCtx) {
        block40: {
            char term;
            int depth;
            block39: {
                depth = 1;
                term = type;
                switch (type) {
                    case '[': {
                        term = ']';
                        break;
                    }
                    case '{': {
                        term = '}';
                        break;
                    }
                    case '(': {
                        term = ')';
                    }
                }
                if (type != term) break block39;
                ++start;
                while (start != chars.length) {
                    if (chars[start] == type) {
                        return start;
                    }
                    ++start;
                }
                break block40;
            }
            int lines = 0;
            ++start;
            while (start < chars.length) {
                block42: {
                    block38: {
                        block41: {
                            if (!ParseTools.isWhitespace(chars[start])) break block41;
                            switch (chars[start]) {
                                case '\r': {
                                    break block42;
                                }
                                case '\n': {
                                    if (pCtx != null) {
                                        pCtx.setLineOffset((short)start);
                                    }
                                    ++lines;
                                }
                            }
                            break block38;
                        }
                        if (start < chars.length && chars[start] == '/') {
                            if (start + 1 == chars.length) {
                                return start;
                            }
                            if (chars[start + 1] == '/') {
                                ++start;
                                while (start < chars.length && chars[start] != '\n') {
                                    ++start;
                                }
                            } else if (chars[start + 1] == '*') {
                                start += 2;
                                block21: while (start != chars.length) {
                                    switch (chars[start]) {
                                        case '*': {
                                            if (start + 1 < chars.length && chars[start + 1] == '/') break block38;
                                        }
                                        case '\n': 
                                        case '\r': {
                                            if (pCtx != null) {
                                                pCtx.setLineOffset((short)start);
                                            }
                                            ++lines;
                                        }
                                        default: {
                                            ++start;
                                            continue block21;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (start == chars.length) {
                        return start;
                    }
                    if (chars[start] == '\'' || chars[start] == '\"') {
                        start = ParseTools.captureStringLiteral(chars[start], chars, start, chars.length);
                    } else if (chars[start] == type) {
                        ++depth;
                    } else if (chars[start] == term && --depth == 0) {
                        if (pCtx != null) {
                            pCtx.incrementLineCount(lines);
                        }
                        return start;
                    }
                }
                ++start;
            }
        }
        switch (type) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", chars, start);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", chars, start);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", chars, start);
            }
        }
        throw new CompileException("unterminated string literal", chars, start);
    }

    public static String handleStringEscapes(char[] input) {
        int escapes = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != '\\') continue;
            escapes += ParseTools.handleEscapeSequence(input, ++i);
        }
        if (escapes == 0) {
            return new String(input);
        }
        char[] processedEscapeString = new char[input.length - escapes];
        int cursor = 0;
        for (char aName : input) {
            if (aName == '\u0000') continue;
            processedEscapeString[cursor++] = aName;
        }
        return new String(processedEscapeString);
    }

    public static int captureStringLiteral(char type, char[] expr, int cursor, int length) {
        while (++cursor < length && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        if (cursor >= length || expr[cursor] != type) {
            throw new CompileException("unterminated literal", expr, cursor);
        }
        return cursor;
    }

    public static void parseWithExpressions(String nestParm, char[] block, int begin, int ending, Object ctx, VariableResolverFactory factory) {
        int start = begin;
        String parm = "";
        int end = -1;
        int oper = -1;
        block7: for (int i = begin; i < ending; ++i) {
            switch (block[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(block, i, block[i]);
                    continue block7;
                }
                case '/': {
                    if (i < ending && block[i + 1] == '/') {
                        while (i < ending && block[i] != '\n') {
                            block[i++] = 32;
                        }
                        if (parm != null) continue block7;
                        start = i;
                        continue block7;
                    }
                    if (i < ending && block[i + 1] == '*') {
                        int len = ending - 1;
                        while (i < len && (block[i] != '*' || block[i + 1] != '/')) {
                            block[i++] = 32;
                        }
                        block[i++] = 32;
                        block[i++] = 32;
                        if (parm != null) continue block7;
                        start = i;
                        continue block7;
                    }
                    if (i >= ending || block[i + 1] != '=') continue block7;
                    oper = 3;
                    continue block7;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i + 1 >= ending || block[i + 1] != '=') continue block7;
                    oper = ParseTools.opLookup(block[i]);
                    continue block7;
                }
                case '=': {
                    parm = new String(block, start, i - start - (oper != -1 ? 1 : 0)).trim();
                    start = i + 1;
                    continue block7;
                }
                case ',': {
                    if (end == -1) {
                        end = i;
                    }
                    if (parm == null) {
                        MVEL.eval(new StringAppender(nestParm).append('.').append(block, start, end - start).toString(), ctx, factory);
                        oper = -1;
                        start = ++i;
                    } else {
                        MVEL.setProperty(ctx, parm, MVEL.eval(new String(ParseTools.createShortFormOperativeAssignment(new StringAppender(nestParm).append(".").append(parm).toString(), ParseTools.subset(block, start, end - start), oper)), ctx, factory));
                        parm = null;
                        oper = -1;
                        start = ++i;
                    }
                    end = -1;
                }
            }
        }
        end = ending;
        if (start != end) {
            if (parm == null || "".equals(parm)) {
                MVEL.eval(new StringAppender(nestParm).append('.').append(block, start, end - start).toString(), ctx, factory);
            } else {
                MVEL.setProperty(ctx, parm, MVEL.eval(new String(ParseTools.createShortFormOperativeAssignment(new StringAppender(nestParm).append(".").append(parm).toString(), ParseTools.subset(block, start, end - start), oper)), ctx, factory));
            }
        }
    }

    public static Object handleNumericConversion(char[] val) {
        if (val.length != 1 && val[0] == '0' && val[1] != '.') {
            if (!ParseTools.isDigit(val[val.length - 1])) {
                switch (val[val.length - 1]) {
                    case 'L': 
                    case 'l': {
                        return Long.decode(new String(val, 0, val.length - 1));
                    }
                    case 'I': {
                        return BigInteger.valueOf(Long.decode(new String(val, 0, val.length - 1)));
                    }
                    case 'D': {
                        return BigDecimal.valueOf(Long.decode(new String(val, 0, val.length - 1)));
                    }
                }
            }
            return Integer.decode(new String(val));
        }
        if (!ParseTools.isDigit(val[val.length - 1])) {
            switch (val[val.length - 1]) {
                case 'L': 
                case 'l': {
                    return Long.parseLong(new String(val, 0, val.length - 1));
                }
                case '.': 
                case 'D': 
                case 'd': {
                    return Double.parseDouble(new String(val, 0, val.length - 1));
                }
                case 'F': 
                case 'f': {
                    return Float.valueOf(Float.parseFloat(new String(val, 0, val.length - 1)));
                }
                case 'I': {
                    return new BigInteger(new String(val, 0, val.length - 1));
                }
                case 'B': {
                    return new BigDecimal(new String(val, 0, val.length - 1));
                }
            }
            throw new CompileException("unrecognized numeric literal");
        }
        switch (ParseTools.numericTest(val)) {
            case 104: {
                return Float.valueOf(Float.parseFloat(new String(val)));
            }
            case 101: {
                return Integer.parseInt(new String(val));
            }
            case 102: {
                return Long.parseLong(new String(val));
            }
            case 103: {
                return Double.parseDouble(new String(val));
            }
            case 110: {
                return new BigDecimal(val, MathContext.DECIMAL128);
            }
        }
        return new String(val);
    }

    public static boolean isNumeric(Object val) {
        if (val == null) {
            return false;
        }
        Class<?> clz = val instanceof Class ? (Class<?>)val : val.getClass();
        return clz == Integer.TYPE || clz == Long.TYPE || clz == Short.TYPE || clz == Double.TYPE || clz == Float.TYPE || Number.class.isAssignableFrom(clz);
    }

    public static int numericTest(char[] val) {
        boolean fp = false;
        int len = val.length;
        int i = 0;
        if (len > 1) {
            if (val[0] == '-') {
                ++i;
            } else if (val[0] == '~') {
                ++i;
                if (val[1] == '-') {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = val[i];
            if (!ParseTools.isDigit(c)) {
                switch (c) {
                    case '.': {
                        fp = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        fp = true;
                        if (i++ >= len || val[i] != '-') break;
                        ++i;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            ++i;
        }
        if (len != 0) {
            if (fp) {
                return 103;
            }
            if (len > 9) {
                return 102;
            }
            return 101;
        }
        return -1;
    }

    public static boolean isNumber(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return ParseTools.isNumber((String)val);
        }
        if (val instanceof char[]) {
            return ParseTools.isNumber((char[])val);
        }
        return val instanceof Integer || val instanceof BigDecimal || val instanceof BigInteger || val instanceof Float || val instanceof Double || val instanceof Long || val instanceof Short || val instanceof Character;
    }

    public static boolean isNumber(String val) {
        int len = val.length();
        boolean f = true;
        int i = 0;
        if (len > 1) {
            if (val.charAt(0) == '-') {
                ++i;
            } else if (val.charAt(0) == '~') {
                ++i;
                if (val.charAt(1) == '-') {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = val.charAt(i);
            if (!ParseTools.isDigit(c)) {
                if (c == '.' && f) {
                    f = false;
                } else {
                    return false;
                }
            }
            ++i;
        }
        return len > 0;
    }

    public static boolean isNumber(char[] val) {
        int len = val.length;
        boolean f = true;
        int i = 0;
        if (len > 1) {
            switch (val[0]) {
                case '-': {
                    if (val[1] == '-') {
                        ++i;
                    }
                }
                case '~': {
                    ++i;
                }
            }
        }
        while (i < len) {
            char c = val[i];
            if (!ParseTools.isDigit(c)) {
                if (f && c == '.') {
                    f = false;
                } else {
                    if (len != 1 && i == len - 1) {
                        switch (c) {
                            case 'B': 
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'L': 
                            case 'd': 
                            case 'f': 
                            case 'l': {
                                return true;
                            }
                            case '.': {
                                throw new CompileException("invalid number literal: " + new String(val));
                            }
                        }
                        return false;
                    }
                    if (i == 1 && c == 'x' && val[0] == '0') {
                        ++i;
                        while (i < len) {
                            c = val[i];
                            if (!(ParseTools.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                                if (i == len - 1) {
                                    switch (c) {
                                        case 'B': 
                                        case 'I': 
                                        case 'L': 
                                        case 'l': {
                                            return true;
                                        }
                                    }
                                }
                                return false;
                            }
                            ++i;
                        }
                        return len - 2 > 0;
                    }
                    if (i != 0 && i + 1 < len && (c == 'E' || c == 'e')) {
                        if (val[++i] == '-' || val[i] == '+') {
                            ++i;
                        }
                    } else {
                        if (i != 0) {
                            throw new CompileException("invalid number literal: " + new String(val));
                        }
                        return false;
                    }
                }
            }
            ++i;
        }
        return len > 0;
    }

    public static int find(char[] c, char find) {
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != find) continue;
            return i;
        }
        return -1;
    }

    public static int findLast(char[] c, char find) {
        for (int i = c.length - 1; i != -1; --i) {
            if (c[i] != find) continue;
            return i;
        }
        return -1;
    }

    public static String createStringTrimmed(char[] s) {
        int start;
        int end = s.length;
        for (start = 0; start != end && s[start] < '!'; ++start) {
        }
        while (end != start && s[end - 1] < '!') {
            --end;
        }
        return new String(s, start, end - start);
    }

    public static String createStringTrimmed(char[] s, int start, int length) {
        if ((length = start + length) > s.length) {
            return new String(s);
        }
        while (start != length && s[start] < '!') {
            ++start;
        }
        while (length != start && s[length - 1] < '!') {
            --length;
        }
        return new String(s, start, length - start);
    }

    public static boolean endsWith(char[] c, char[] test) {
        if (test.length > c.length) {
            return false;
        }
        int tD = test.length - 1;
        int cD = c.length - 1;
        while (tD != -1) {
            if (c[cD--] == test[tD--]) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierPart(int c) {
        return c > 96 && c < 123 || c > 64 && c < 91 || c > 47 && c < 58 || c == 95 || c == 36 || Character.isJavaIdentifierPart(c);
    }

    public static boolean isDigit(int c) {
        return c > 47 && c < 58;
    }

    public static float similarity(String s1, String s2) {
        char[] against;
        char[] comp;
        float baselength;
        if (s1 == null || s2 == null) {
            return s1 == null && s2 == null ? 1.0f : 0.0f;
        }
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        float same = 0.0f;
        int cur1 = 0;
        if (c1.length > c2.length) {
            baselength = c1.length;
            comp = c1;
            against = c2;
        } else {
            baselength = c2.length;
            comp = c2;
            against = c1;
        }
        while (cur1 < comp.length && cur1 < against.length) {
            if (comp[cur1] == against[cur1]) {
                same += 1.0f;
            }
            ++cur1;
        }
        return same / baselength;
    }

    public static int findAbsoluteLast(char[] array) {
        int depth = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == ']') {
                ++depth;
            }
            if (array[i] == '[') {
                --depth;
            }
            if ((depth != 0 || array[i] != '.') && array[i] != '[') continue;
            return i;
        }
        return -1;
    }

    public static Class getBaseComponentType(Class cls) {
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static Class getSubComponentType(Class cls) {
        if (cls.isArray()) {
            cls = cls.getComponentType();
        }
        return cls;
    }

    public static boolean isJunct(char c) {
        switch (c) {
            case '(': 
            case '[': {
                return true;
            }
        }
        return ParseTools.isWhitespace(c);
    }

    public static int opLookup(char c) {
        switch (c) {
            case '|': {
                return 7;
            }
            case '&': {
                return 6;
            }
            case '^': {
                return 8;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 3;
            }
            case '+': {
                return 0;
            }
            case '%': {
                return 4;
            }
            case '\u00ab': {
                return 10;
            }
            case '\u00bb': {
                return 9;
            }
            case '\u00ac': {
                return 11;
            }
        }
        return -1;
    }

    public static boolean isReservedWord(String name) {
        return AbstractParser.LITERALS.containsKey(name) || AbstractParser.OPERATORS.containsKey(name);
    }

    public static boolean isNotValidNameorLabel(String name) {
        for (char c : name.toCharArray()) {
            if (c == '.') {
                return true;
            }
            if (ParseTools.isIdentifierPart(c)) continue;
            return true;
        }
        return false;
    }

    public static void checkNameSafety(String name) {
        if (ParseTools.isReservedWord(name)) {
            throw new CompileException("illegal use of reserved word: " + name);
        }
        if (ParseTools.isDigit(name.charAt(0))) {
            throw new CompileException("not an identifier");
        }
    }

    public static FileWriter getDebugFileWriter() throws IOException {
        return new FileWriter(new File(MVEL.getDebuggingOutputFileName()), true);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
    }

    public static Serializable subCompileExpression(char[] expression) {
        return ParseTools._optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable subCompileExpression(char[] expression, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression);
        if (ctx != null) {
            c.setPCtx(ctx);
        }
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable subCompileExpression(String expression, ParserContext ctx) {
        ExpressionCompiler c = new ExpressionCompiler(expression);
        c.setPCtx(ctx);
        return ParseTools._optimizeTree(c._compile());
    }

    public static Serializable optimizeTree(CompiledExpression compiled) {
        if (!compiled.isImportInjectionRequired() && compiled.getParserContext().isAllowBootstrapBypass() && compiled.isSingleNode()) {
            return ParseTools._optimizeTree(compiled);
        }
        return compiled;
    }

    private static Serializable _optimizeTree(CompiledExpression compiled) {
        if (compiled.isSingleNode()) {
            ASTNode tk = compiled.getFirstNode();
            if (tk.isLiteral() && !tk.isThisVal()) {
                return new ExecutableLiteral(tk.getLiteralValue());
            }
            return tk.canSerializeAccessor() ? new ExecutableAccessorSafe(tk, compiled.getKnownEgressType()) : new ExecutableAccessor(tk, compiled.getKnownEgressType());
        }
        return compiled;
    }

    public static boolean isWhitespace(char c) {
        return c < '!';
    }

    public static String repeatChar(char c, int times) {
        char[] n = new char[times];
        for (int i = 0; i < times; ++i) {
            n[i] = c;
        }
        return new String(n);
    }

    public static char[] loadFromFile(File file) throws IOException {
        return ParseTools.loadFromFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFromFile(File file, String encoding) throws IOException {
        if (!file.exists()) {
            throw new CompileException("cannot find file: " + file.getName());
        }
        FileInputStream inStream = null;
        FileChannel fc = null;
        try {
            inStream = new FileInputStream(file);
            fc = inStream.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect(10);
            StringAppender sb = new StringAppender((int)file.length(), encoding);
            int read = 0;
            while (read >= 0) {
                buf.rewind();
                buf.rewind();
                for (read = fc.read(buf); read > 0; --read) {
                    sb.append(buf.get());
                }
            }
            char[] cArray = sb.toChars();
            return cArray;
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (fc != null) {
                fc.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readIn(InputStream inStream, String encoding) throws IOException {
        try {
            int bytesRead;
            byte[] buf = new byte[10];
            StringAppender sb = new StringAppender(10, encoding);
            while ((bytesRead = inStream.read(buf)) > 0) {
                for (int i = 0; i < bytesRead; ++i) {
                    sb.append(buf[i]);
                }
            }
            char[] cArray = sb.toChars();
            return cArray;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    static {
        try {
            double version = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
            if (version < 1.5) {
                throw new RuntimeException("unsupported java version: " + version);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("unable to initialize math processor", e);
        }
        RESOLVED_METH_CACHE = new WeakHashMap<String, Map<Integer, WeakReference<Method>>>(10);
        RESOLVED_CONST_CACHE = new WeakHashMap<Class, Map<Integer, WeakReference<Constructor>>>(10);
        CONSTRUCTOR_PARMS_CACHE = new WeakHashMap<Constructor, WeakReference<Class[]>>(10);
        CLASS_RESOLVER_CACHE = new WeakHashMap<ClassLoader, Map<String, WeakReference<Class>>>(1, 1.0f);
        CLASS_CONSTRUCTOR_CACHE = new WeakHashMap<Class, WeakReference<Constructor[]>>(10);
        HashMap<Class, Integer> t = typeResolveMap = new HashMap();
        t.put(BigDecimal.class, 110);
        t.put(BigInteger.class, 111);
        t.put(String.class, 1);
        t.put(Integer.TYPE, 101);
        t.put(Integer.class, 106);
        t.put(Short.TYPE, 100);
        t.put(Short.class, 105);
        t.put(Float.TYPE, 104);
        t.put(Float.class, 108);
        t.put(Double.TYPE, 103);
        t.put(Double.class, 109);
        t.put(Long.TYPE, 102);
        t.put(Long.class, 107);
        t.put(Boolean.TYPE, 7);
        t.put(Boolean.class, 15);
        t.put(Byte.TYPE, 9);
        t.put(Byte.class, 113);
        t.put(Character.TYPE, 8);
        t.put(Character.class, 112);
        t.put(BlankLiteral.class, 200);
    }

    public static final class WithStatementPair
    implements Serializable {
        private String parm;
        private String value;

        public WithStatementPair(String parm, String value) {
            this.parm = parm;
            this.value = value;
        }

        public String getParm() {
            return this.parm;
        }

        public void setParm(String parm) {
            this.parm = parm;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void eval(Object ctx, VariableResolverFactory vrf) {
            if (this.parm == null) {
                MVEL.eval(this.value, ctx, vrf);
            } else {
                MVEL.setProperty(ctx, this.parm, MVEL.eval(this.value, ctx, vrf));
            }
        }
    }
}

