/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ldap.LdapEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class LdapProducer
extends DefaultProducer {
    private String remaining;
    private SearchControls searchControls;
    private String searchBase;
    private Integer pageSize;

    public LdapProducer(LdapEndpoint endpoint, String remaining, String base, int scope, Integer pageSize, String returnedAttributes) throws Exception {
        super((Endpoint)endpoint);
        this.remaining = remaining;
        this.searchBase = base;
        this.pageSize = pageSize;
        this.searchControls = new SearchControls();
        this.searchControls.setSearchScope(scope);
        if (returnedAttributes != null) {
            Object[] returnedAtts = returnedAttributes.split(",");
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setting returning Attributes to searchControls: {}", (Object)Arrays.toString(returnedAtts));
            }
            this.searchControls.setReturningAttributes((String[])returnedAtts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String filter = (String)exchange.getIn().getBody(String.class);
        DirContext dirContext = this.getDirContext();
        try {
            List<SearchResult> data;
            if (this.pageSize == null) {
                data = this.simpleSearch(dirContext, filter);
            } else {
                if (!(dirContext instanceof LdapContext)) {
                    throw new IllegalArgumentException("When using attribute 'pageSize' for a ldap endpoint, you must provide a LdapContext (subclass of DirContext)");
                }
                data = this.pagedSearch((LdapContext)dirContext, filter);
            }
            exchange.getOut().setBody(data);
            exchange.getOut().setHeaders(exchange.getIn().getHeaders());
            exchange.getOut().setAttachments(exchange.getIn().getAttachments());
        }
        finally {
            dirContext.close();
        }
    }

    protected DirContext getDirContext() {
        DirContext dirContext = (DirContext)this.getEndpoint().getCamelContext().getRegistry().lookup(this.remaining);
        return dirContext;
    }

    private List<SearchResult> simpleSearch(DirContext ldapContext, String searchFilter) throws NamingException {
        ArrayList<SearchResult> data = new ArrayList<SearchResult>();
        NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(this.searchBase, searchFilter, this.searchControls);
        while (namingEnumeration != null && namingEnumeration.hasMore()) {
            data.add(namingEnumeration.next());
        }
        return data;
    }

    private List<SearchResult> pagedSearch(LdapContext ldapContext, String searchFilter) throws Exception {
        ArrayList<SearchResult> data = new ArrayList<SearchResult>();
        this.log.trace("Using paged ldap search, pageSize={}", (Object)this.pageSize);
        Control[] requestControls = new Control[]{new PagedResultsControl(this.pageSize, true)};
        ldapContext.setRequestControls(requestControls);
        do {
            List<SearchResult> pageResult = this.simpleSearch(ldapContext, searchFilter);
            data.addAll(pageResult);
            this.log.trace("Page returned {} entries", (Object)pageResult.size());
        } while (this.prepareNextPage(ldapContext));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found a total of {} entries for ldap filter {}", (Object)data.size(), (Object)searchFilter);
        }
        return data;
    }

    private boolean prepareNextPage(LdapContext ldapContext) throws Exception {
        Control[] responseControls = ldapContext.getResponseControls();
        byte[] cookie = null;
        if (responseControls != null) {
            for (Control responseControl : responseControls) {
                if (!(responseControl instanceof PagedResultsResponseControl)) continue;
                PagedResultsResponseControl prrc = (PagedResultsResponseControl)responseControl;
                cookie = prrc.getCookie();
            }
        }
        if (cookie == null) {
            return false;
        }
        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(this.pageSize, cookie, true)});
        return true;
    }
}

