/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.nmr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.servicemix.cxf.transport.nmr.NMRDestinationOutputStream;
import org.apache.servicemix.cxf.transport.nmr.NMRMessageHelper;
import org.apache.servicemix.cxf.transport.nmr.NMRTransportFactory;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.ServiceMixException;
import org.apache.servicemix.nmr.api.Status;

public class NMRDestination
extends AbstractDestination
implements Endpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(NMRDestination.class);
    private NMR nmr;
    private Channel channel;
    private Map<String, Object> properties;

    public NMRDestination(EndpointInfo info, NMR nmr) {
        super(NMRDestination.getTargetReference((EndpointInfo)info, null), info);
        this.nmr = nmr;
        this.properties = new HashMap<String, Object>();
        String address = info.getAddress();
        if (address != null && address.indexOf("RUN_AS_SUBJECT") >= 0) {
            String asSubject = address.substring(address.indexOf("RUN_AS_SUBJECT") + "RUN_AS_SUBJECT".length() + 1);
            this.properties.put("RUN_AS_SUBJECT", asSubject);
        }
        if (address != null && address.startsWith("nmr:")) {
            if (address.indexOf("?") > 0) {
                this.properties.put("NAME", address.substring(4, address.indexOf("?")));
            } else {
                this.properties.put("NAME", address.substring(4));
            }
        } else {
            this.properties.put("NAME", info.getName().toString());
        }
        this.properties.put("SERVICE_NAME", info.getService().getName().toString());
        this.properties.put("INTERFACE_NAME", info.getInterface().getName().toString());
    }

    public void setChannel(Channel dc) {
        this.channel = dc;
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), inMessage);
    }

    public void shutdown() {
    }

    public void deactivate() {
        this.nmr.getEndpointRegistry().unregister((Endpoint)this, this.properties);
    }

    public void activate() {
        this.nmr.getEndpointRegistry().register((Endpoint)this, this.properties);
    }

    public void process(Exchange exchange) {
        if (exchange == null || exchange.getStatus() != Status.Active) {
            return;
        }
        if (exchange.getPattern() == Pattern.InOnly || exchange.getPattern() == Pattern.RobustInOnly) {
            exchange.setStatus(Status.Done);
            this.getChannel().send(exchange);
        }
        QName opName = exchange.getOperation();
        this.getLogger().fine("dispatch method: " + opName);
        org.apache.servicemix.nmr.api.Message nm = exchange.getIn();
        try {
            MessageImpl inMessage = new MessageImpl();
            inMessage.put(Exchange.class, (Object)exchange);
            InputStream in = NMRMessageHelper.convertMessageToInputStream((Source)nm.getBody(Source.class));
            inMessage.setContent(InputStream.class, (Object)in);
            ArrayList<AttachmentImpl> cxfAttachmentList = new ArrayList<AttachmentImpl>();
            for (Map.Entry ent : nm.getAttachments().entrySet()) {
                cxfAttachmentList.add(new AttachmentImpl((String)ent.getKey(), (DataHandler)ent.getValue()));
            }
            inMessage.setAttachments(cxfAttachmentList);
            for (Map.Entry ent : nm.getHeaders().entrySet()) {
                if (((String)ent.getKey()).equals("org.apache.cxf.client")) continue;
                inMessage.put((String)ent.getKey(), ent.getValue());
            }
            inMessage.put(NMRTransportFactory.NMR_SECURITY_SUBJECT, (Object)nm.getSecuritySubject());
            inMessage.setDestination((Destination)this);
            this.getMessageObserver().onMessage((Message)inMessage);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.PREPARE.MESSAGE", this.getLogger(), new Object[0]).toString(), ex);
            throw new ServiceMixException((Throwable)ex);
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        protected NMRDestination nmrDestination;

        BackChannelConduit(EndpointReferenceType ref, Message message) {
            super(ref);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(Message message) throws IOException {
            Channel dc = NMRDestination.this.channel;
            message.put(Exchange.class, this.inMessage.get(Exchange.class));
            NMRTransportFactory.removeUnusedInterceptprs(message);
            message.setContent(OutputStream.class, (Object)new NMRDestinationOutputStream(this.inMessage, message, dc));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

