/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.cxf.transport.nmr;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.servicemix.cxf.transport.nmr.NMRTransportFactory;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.w3c.dom.Document;

public class NMRDestinationOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(NMRDestinationOutputStream.class);
    private Message inMessage;
    private Message outMessage;
    private Channel channel;

    public NMRDestinationOutputStream(Message m, Message outM, Channel dc) {
        this.inMessage = m;
        this.outMessage = outM;
        this.channel = dc;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.commitOutputMessage();
    }

    protected void onWrite() throws IOException {
    }

    private void commitOutputMessage() throws IOException {
        try {
            if (this.inMessage.getExchange().isOneWay()) {
                return;
            }
            InputStream bais = this.getInputStream();
            LOG.finest(new org.apache.cxf.common.i18n.Message("BUILDING.DOCUMENT", LOG, new Object[0]).toString());
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(bais);
            Exchange xchng = (Exchange)this.inMessage.get(Exchange.class);
            LOG.fine(new org.apache.cxf.common.i18n.Message("CREATE.NORMALIZED.MESSAGE", LOG, new Object[0]).toString());
            if (this.inMessage.getExchange().getOutFaultMessage() != null) {
                Fault f = (Fault)this.inMessage.getContent(Exception.class);
                if (f.hasDetails()) {
                    xchng.getFault().setBody((Object)new DOMSource(doc));
                } else {
                    xchng.setError((Exception)f);
                }
            } else {
                if (this.outMessage != null && this.outMessage.getAttachments() != null) {
                    for (Attachment att : this.outMessage.getAttachments()) {
                        xchng.getOut().addAttachment(att.getId(), (Object)att.getDataHandler());
                    }
                }
                for (Map.Entry ent : this.outMessage.entrySet()) {
                    if (!(ent.getValue() instanceof Serializable) || ent.getValue() instanceof Map || ent.getValue() instanceof Collection) continue;
                    xchng.getOut().setHeader((String)ent.getKey(), ent.getValue());
                }
                xchng.getOut().setSecuritySubject((Subject)this.outMessage.get((Object)NMRTransportFactory.NMR_SECURITY_SUBJECT));
                xchng.getOut().setBody((Object)new DOMSource(doc));
            }
            LOG.fine(new org.apache.cxf.common.i18n.Message("POST.DISPATCH", LOG, new Object[0]).toString());
            this.channel.send(xchng);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.SEND.MESSAGE", LOG, new Object[0]).toString(), ex);
        }
    }
}

