/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.jndi;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.guiceyfruit.Injectors;
import org.guiceyfruit.jndi.JndiBindings;
import org.guiceyfruit.jndi.internal.JndiContext;

public class GuiceInitialContextFactory
implements InitialContextFactory {
    public static final String NAME_PREFIX = "org.guiceyfruit.jndi/";

    public Context getInitialContext(final Hashtable environment) throws NamingException {
        try {
            Injector injector = Injectors.createInjector(environment, new AbstractModule(){

                protected void configure() {
                    this.bind(Context.class).toProvider(new Provider<Context>(){
                        @Inject
                        Injector injector;

                        @Override
                        public Context get() {
                            JndiContext context = new JndiContext(environment);
                            Properties jndiNames = GuiceInitialContextFactory.this.createJndiNamesProperties(environment);
                            try {
                                JndiBindings.bindInjectorAndBindings(context, this.injector, jndiNames);
                                return context;
                            }
                            catch (NamingException e) {
                                throw new ProvisionException("Failed to create JNDI bindings. Reason: " + e, e);
                            }
                        }
                    }).in(Scopes.SINGLETON);
                }
            });
            return injector.getInstance(Context.class);
        }
        catch (Exception e) {
            NamingException exception = new NamingException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private Properties createJndiNamesProperties(Hashtable environment) {
        Set set = environment.entrySet();
        Properties answer = new Properties();
        for (Map.Entry entry : set) {
            String key = entry.getKey().toString();
            if (!key.startsWith(NAME_PREFIX)) continue;
            String name = key.substring(NAME_PREFIX.length());
            Object value = entry.getValue();
            answer.put(name, value);
        }
        return answer;
    }
}

