/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.jndi;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.guiceyfruit.jndi.JndiBind;
import org.guiceyfruit.jndi.internal.Classes;

public class JndiBindings {
    public static void bindInjectorAndBindings(Context context, Injector injector, Properties jndiNames) throws NamingException {
        Set<Map.Entry<Key<?>, Binding<?>>> entries = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries) {
            Provider<?> value;
            Key<?> key = entry.getKey();
            Binding<?> binding = entry.getValue();
            Annotation annotation = key.getAnnotation();
            Type type = key.getTypeLiteral().getType();
            JndiBind jndiBind = null;
            if (type instanceof Class) {
                Class aClass = (Class)type;
                jndiBind = aClass.getAnnotation(JndiBind.class);
            }
            if (annotation instanceof JndiBind) {
                jndiBind = (JndiBind)annotation;
            }
            String jndiName = null;
            if (jndiBind != null) {
                jndiName = jndiBind.value();
            }
            if (jndiName == null) {
                if (annotation instanceof Named) {
                    Named named = (Named)annotation;
                    String name = named.value();
                    jndiName = type.toString() + "/" + name;
                } else if (type instanceof Class) {
                    Class aClass = (Class)type;
                    jndiName = annotation == null ? aClass.getName() : aClass.getName() + annotation;
                }
            }
            if (jndiName == null || (value = binding.getProvider()) == null) continue;
            context.bind(jndiName, value);
        }
        for (Map.Entry<Object, Object> entry : jndiNames.entrySet()) {
            String jndiName = entry.getKey().toString();
            String expression = entry.getValue().toString();
            Provider provider = JndiBindings.getProviderForExpression(injector, expression);
            if (provider == null) continue;
            context.bind(jndiName, (Object)provider);
        }
    }

    static Provider getProviderForExpression(Injector injector, String expression) {
        try {
            Class<?> type = Classes.loadClass(expression, JndiBindings.class.getClassLoader());
            return injector.getProvider(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

