/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.jsr250;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotatedMethodCache {
    private final Class<? extends Annotation> annotationType;
    private Map<Class<?>, Method> methodCache = Collections.synchronizedMap(new WeakHashMap());

    public AnnotatedMethodCache(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    public Method getMethod(Class<?> type) {
        Method method = this.methodCache.get(type);
        if (method == null && (method = this.findMethodWithAnnotation(type, this.annotationType)) != null) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException("Method should have no arguments for @PostConstruct " + method);
            }
            this.methodCache.put(type, method);
        }
        return method;
    }

    protected Method findMethodWithAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
        Class<?> superclass;
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            Annotation fromElement = method.getAnnotation(annotationType);
            if (fromElement == null) continue;
            return method;
        }
        if (!Object.class.equals(type) && (superclass = type.getSuperclass()) != null) {
            return this.findMethodWithAnnotation(superclass, annotationType);
        }
        return null;
    }
}

