/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.support;

import com.google.inject.internal.Iterables;
import java.util.Collection;
import org.guiceyfruit.support.Closer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCloser
implements Closer {
    private final Iterable<Closer> closers;

    public static Closer newInstance(Collection<Closer> closers) {
        if (closers.isEmpty()) {
            return null;
        }
        if (closers.size() == 1) {
            return Iterables.getOnlyElement(closers);
        }
        return new CompositeCloser(closers);
    }

    public CompositeCloser(Iterable<Closer> closers) {
        this.closers = closers;
    }

    @Override
    public void close(Object object) throws Throwable {
        for (Closer closer : this.closers) {
            closer.close(object);
        }
    }
}

