/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.VDC;

@Singleton
public final class IsDefaultVDC
implements Predicate<Location> {
    private final ReferenceType defaultVDC;

    @Inject
    IsDefaultVDC(@VDC ReferenceType defaultVDC) {
        this.defaultVDC = (ReferenceType)Preconditions.checkNotNull((Object)defaultVDC, (Object)"defaultVDC");
    }

    public boolean apply(Location input) {
        return input.getScope() == LocationScope.ZONE && input.getId().equals(this.defaultVDC.getHref().toASCIIString());
    }

    public String toString() {
        return "isDefaultVDC()";
    }
}

