/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.compute.functions.VCloudHardwareBuilderFromResourceAllocations;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.ovf.VCloudVirtualHardwareSection;

public class HardwareForVApp
implements Function<VApp, Hardware> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Function<ReferenceType, Location> findLocationForResource;
    private final VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder;

    @Inject
    protected HardwareForVApp(Function<ReferenceType, Location> findLocationForResource, VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder) {
        this.findLocationForResource = (Function)Preconditions.checkNotNull(findLocationForResource, (Object)"findLocationForResource");
        this.rasdToHardwareBuilder = (VCloudHardwareBuilderFromResourceAllocations)((Object)Preconditions.checkNotNull((Object)((Object)rasdToHardwareBuilder), (Object)"rasdToHardwareBuilder"));
    }

    public Hardware apply(VApp from) {
        Vm vm;
        Preconditions.checkNotNull((Object)from, (Object)"VApp");
        Vm vm2 = vm = from.getChildren().size() == 0 ? null : (Vm)Iterables.get(from.getChildren(), (int)0);
        if (vm == null) {
            return null;
        }
        VCloudVirtualHardwareSection hardware = vm.getVirtualHardwareSection();
        HardwareBuilder builder = this.rasdToHardwareBuilder.apply(hardware.getItems());
        builder.location((Location)this.findLocationForResource.apply((Object)((VApp)Preconditions.checkNotNull((Object)from, (Object)"from")).getVDC()));
        builder.ids(from.getHref().toASCIIString()).name(from.getName()).supportsImage(ImagePredicates.idEquals((String)from.getHref().toASCIIString()));
        return builder.build();
    }
}

