/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.VirtualHardwareSection;
import org.jclouds.ovf.VirtualSystem;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.VCloudHardwareBuilderFromResourceAllocations;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class HardwareForVAppTemplate
implements Function<VAppTemplate, Hardware> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Function<VAppTemplate, Envelope> templateToEnvelope;
    private final FindLocationForResource findLocationForResource;
    private final VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder;

    @Inject
    protected HardwareForVAppTemplate(Function<VAppTemplate, Envelope> templateToEnvelope, FindLocationForResource findLocationForResource, VCloudHardwareBuilderFromResourceAllocations rasdToHardwareBuilder) {
        this.templateToEnvelope = (Function)Preconditions.checkNotNull(templateToEnvelope, (Object)"templateToEnvelope");
        this.findLocationForResource = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResource, (Object)"findLocationForResource");
        this.rasdToHardwareBuilder = (VCloudHardwareBuilderFromResourceAllocations)((Object)Preconditions.checkNotNull((Object)((Object)rasdToHardwareBuilder), (Object)"rasdToHardwareBuilder"));
    }

    public Hardware apply(VAppTemplate from) {
        Preconditions.checkNotNull((Object)from, (Object)"VAppTemplate");
        Envelope ovf = (Envelope)this.templateToEnvelope.apply((Object)from);
        if (((VirtualSystem)ovf.getVirtualSystem()).getVirtualHardwareSections().size() > 1) {
            this.logger.warn("multiple hardware choices found. using first", new Object[]{ovf});
        }
        VirtualHardwareSection hardware = (VirtualHardwareSection)Iterables.get((Iterable)((VirtualSystem)ovf.getVirtualSystem()).getVirtualHardwareSections(), (int)0);
        HardwareBuilder builder = this.rasdToHardwareBuilder.apply(hardware.getItems());
        if (from.getVDC() != null) {
            builder.location(this.findLocationForResource.apply(from.getVDC()));
        }
        builder.ids(from.getHref().toASCIIString()).name(from.getName()).supportsImage(ImagePredicates.idEquals((String)from.getHref().toASCIIString()));
        return builder.build();
    }

    protected String getName(String name) {
        return name;
    }
}

