/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Network;
import org.jclouds.predicates.validators.DnsNameValidator;
import org.jclouds.vcloud.TaskStillRunningException;
import org.jclouds.vcloud.VCloudClient;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.compute.util.VCloudComputeUtils;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;

@Singleton
public class InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final VCloudClient client;
    protected final Predicate<URI> successTester;
    protected final LoadingCache<URI, VAppTemplate> vAppTemplates;
    protected final NetworkConfig defaultNetworkConfig;
    protected final String buildVersion;
    Predicate<Network> networkWithNoIpAllocation = new Predicate<Network>(){

        public boolean apply(Network input) {
            return "none".equals(input.getName());
        }
    };

    @Inject
    protected InstantiateVAppTemplateWithGroupEncodedIntoNameThenCustomizeDeployAndPowerOn(VCloudClient client, Predicate<URI> successTester, LoadingCache<URI, VAppTemplate> vAppTemplates, NetworkConfig defaultNetworkConfig, @Named(value="jclouds.build-version") String buildVersion) {
        this.client = client;
        this.successTester = successTester;
        this.vAppTemplates = vAppTemplates;
        this.defaultNetworkConfig = defaultNetworkConfig;
        this.buildVersion = buildVersion;
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VApp> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        ComputerNameValidator.INSTANCE.validate(name);
        URI templateId = URI.create(template.getImage().getId());
        VAppTemplate vAppTemplate = (VAppTemplate)this.vAppTemplates.getUnchecked((Object)templateId);
        if (vAppTemplate.getChildren().size() > 1) {
            throw new UnsupportedOperationException("we currently do not support multiple vms in a vAppTemplate " + vAppTemplate);
        }
        if (vAppTemplate.getNetworkSection().getNetworks().size() > 1) {
            throw new UnsupportedOperationException("we currently do not support multiple network connections in a vAppTemplate " + vAppTemplate);
        }
        Network networkToConnect = (Network)Iterables.get((Iterable)vAppTemplate.getNetworkSection().getNetworks(), (int)0);
        NetworkConfig config = this.networkWithNoIpAllocation.apply((Object)networkToConnect) ? this.defaultNetworkConfig : this.defaultNetworkConfig.toBuilder().networkName(networkToConnect.getName()).build();
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.addNetworkConfig(config);
        String customizationScript = ((VCloudTemplateOptions)VCloudTemplateOptions.class.cast(template.getOptions())).getCustomizationScript();
        IpAddressAllocationMode ipAllocationMode = ((VCloudTemplateOptions)VCloudTemplateOptions.class.cast(template.getOptions())).getIpAddressAllocationMode();
        String description = ((VCloudTemplateOptions)VCloudTemplateOptions.class.cast(template.getOptions())).getDescription();
        if (description == null) {
            description = vAppTemplate.getName();
        }
        options.description(description);
        options.deploy(false);
        options.powerOn(false);
        URI VDC2 = URI.create(template.getLocation().getId());
        this.logger.debug(">> instantiating vApp vDC(%s) template(%s) name(%s) options(%s) ", new Object[]{VDC2, templateId, name, options});
        VApp vAppResponse = this.client.getVAppTemplateClient().createVAppInVDCByInstantiatingTemplate(name, VDC2, templateId, options);
        this.waitForTask(vAppResponse.getTasks().get(0));
        this.logger.debug("<< instantiated VApp(%s)", new Object[]{vAppResponse.getName()});
        vAppResponse = this.client.getVAppClient().getVApp(vAppResponse.getHref());
        Vm vm = (Vm)Iterables.get(vAppResponse.getChildren(), (int)0);
        this.logger.trace(">> updating customization vm(%s) name->(%s)", new Object[]{vm.getName(), name});
        this.waitForTask(this.updateVmWithNameAndCustomizationScript(vm, name, customizationScript));
        this.logger.trace("<< updated customization vm(%s)", new Object[]{name});
        this.ensureVmHasAllocationModeOrPooled(vAppResponse, ipAllocationMode);
        int cpuCount = new Double(ComputeServiceUtils.getCores((Hardware)template.getHardware())).intValue();
        this.logger.trace(">> updating cpuCount(%d) vm(%s)", new Object[]{cpuCount, vm.getName()});
        this.waitForTask(this.updateCPUCountOfVm(vm, cpuCount));
        this.logger.trace("<< updated cpuCount vm(%s)", new Object[]{vm.getName()});
        int memoryMB = template.getHardware().getRam();
        this.logger.trace(">> updating memoryMB(%d) vm(%s)", new Object[]{memoryMB, vm.getName()});
        this.waitForTask(this.updateMemoryMBOfVm(vm, memoryMB));
        this.logger.trace("<< updated memoryMB vm(%s)", new Object[]{vm.getName()});
        this.logger.trace(">> deploying vApp(%s)", new Object[]{vAppResponse.getName()});
        this.waitForTask(this.client.getVAppClient().deployVApp(vAppResponse.getHref()));
        this.logger.trace("<< deployed vApp(%s)", new Object[]{vAppResponse.getName()});
        vAppResponse = this.client.getVAppClient().getVApp(vAppResponse.getHref());
        this.logger.trace(">> powering on vApp(%s)", new Object[]{vAppResponse.getName()});
        this.client.getVAppClient().powerOnVApp(vAppResponse.getHref());
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)vAppResponse, vAppResponse.getHref().toASCIIString(), VCloudComputeUtils.getCredentialsFrom(vAppResponse));
    }

    public void waitForTask(Task task) {
        if (!this.successTester.apply((Object)task.getHref())) {
            throw new TaskStillRunningException(task);
        }
    }

    public Task updateVmWithNameAndCustomizationScript(Vm vm, String name, @Nullable String customizationScript) {
        GuestCustomizationSection guestConfiguration = vm.getGuestCustomizationSection();
        guestConfiguration.setComputerName(name);
        if (customizationScript != null) {
            if (!this.buildVersion.startsWith("1.0.0") && !"".endsWith(this.buildVersion) && guestConfiguration.getCustomizationScript() != null) {
                customizationScript = guestConfiguration.getCustomizationScript() + "\n" + customizationScript;
            }
            guestConfiguration.setCustomizationScript(customizationScript);
        }
        return this.client.getVmClient().updateGuestCustomizationOfVm(guestConfiguration, vm.getHref());
    }

    public void ensureVmHasAllocationModeOrPooled(VApp vApp, @Nullable IpAddressAllocationMode ipAllocationMode) {
        Network networkToConnect = (Network)Iterables.find((Iterable)vApp.getNetworkSection().getNetworks(), (Predicate)Predicates.not(this.networkWithNoIpAllocation));
        Vm vm = (Vm)Iterables.get(vApp.getChildren(), (int)0);
        NetworkConnectionSection net = vm.getNetworkConnectionSection();
        Preconditions.checkArgument((net.getConnections().size() > 0 ? 1 : 0) != 0, (String)"no connections on vm %s", (Object[])new Object[]{vm});
        NetworkConnection toConnect = this.findWithPoolAllocationOrFirst(net);
        if (ipAllocationMode == null) {
            ipAllocationMode = toConnect.getIpAddressAllocationMode();
        }
        if (ipAllocationMode == IpAddressAllocationMode.NONE) {
            ipAllocationMode = IpAddressAllocationMode.POOL;
        }
        if (!toConnect.isConnected() || toConnect.getIpAddressAllocationMode() != ipAllocationMode || !toConnect.getNetwork().equals(networkToConnect.getName())) {
            NetworkConnectionSection.Builder builder = net.toBuilder();
            builder.connections((Iterable<NetworkConnection>)ImmutableSet.of((Object)toConnect.toBuilder().network(networkToConnect.getName()).connected(true).ipAddressAllocationMode(ipAllocationMode).build()));
            this.logger.trace(">> updating networkConnection vm(%s)", new Object[]{vm.getName()});
            this.waitForTask(this.client.getVmClient().updateNetworkConnectionOfVm(builder.build(), vm.getHref()));
            this.logger.trace("<< updated networkConnection vm(%s)", new Object[]{vm.getName()});
        }
    }

    private NetworkConnection findWithPoolAllocationOrFirst(NetworkConnectionSection net) {
        return (NetworkConnection)Iterables.find(net.getConnections(), (Predicate)new Predicate<NetworkConnection>(){

            public boolean apply(NetworkConnection input) {
                return input.getIpAddressAllocationMode() == IpAddressAllocationMode.POOL;
            }
        }, (Object)Iterables.get(net.getConnections(), (int)0));
    }

    public Task updateCPUCountOfVm(Vm vm, int cpuCount) {
        return this.client.getVmClient().updateCPUCountOfVm(cpuCount, vm.getHref());
    }

    public Task updateMemoryMBOfVm(Vm vm, int memoryInMB) {
        return this.client.getVmClient().updateMemoryMBOfVm(memoryInMB, vm.getHref());
    }

    public static enum ComputerNameValidator {
        INSTANCE;

        private DnsNameValidator validator = new DnsNameValidator(3, 15);

        public void validate(@Nullable String t) throws IllegalArgumentException {
            this.validator.validate(t);
        }
    }
}

