/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkSection;

public class VAppImpl
extends ReferenceTypeImpl
implements VApp {
    private final Status status;
    private final ReferenceType vdc;
    @Nullable
    private final String description;
    private final List<Task> tasks = Lists.newArrayList();
    private final boolean ovfDescriptorUploaded;
    private final Set<Vm> children = Sets.newLinkedHashSet();
    @Nullable
    private final VCloudNetworkSection networkSection;

    public VAppImpl(String name, String type, URI id, Status status, ReferenceType vdc, @Nullable String description, Iterable<Task> tasks, boolean ovfDescriptorUploaded, Iterable<Vm> children, @Nullable VCloudNetworkSection networkSection) {
        super(name, type, id);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.vdc = vdc;
        this.description = description;
        Iterables.addAll(this.tasks, (Iterable)((Iterable)Preconditions.checkNotNull(tasks, (Object)"tasks")));
        this.ovfDescriptorUploaded = ovfDescriptorUploaded;
        Iterables.addAll(this.children, (Iterable)((Iterable)Preconditions.checkNotNull(children, (Object)"children")));
        this.networkSection = networkSection;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public ReferenceType getVDC() {
        return this.vdc;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public boolean isOvfDescriptorUploaded() {
        return this.ovfDescriptorUploaded;
    }

    @Override
    public Set<Vm> getChildren() {
        return this.children;
    }

    @Override
    public VCloudNetworkSection getNetworkSection() {
        return this.networkSection;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.ovfDescriptorUploaded ? 1231 : 1237);
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.tasks == null ? 0 : ((Object)this.tasks).hashCode());
        result = 31 * result + (this.vdc == null ? 0 : this.vdc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VAppImpl other = (VAppImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.ovfDescriptorUploaded != other.ovfDescriptorUploaded) {
            return false;
        }
        return !(this.vdc == null ? other.vdc != null : !this.vdc.equals(other.vdc));
    }

    @Override
    public String toString() {
        return "[id=" + this.getHref() + ", name=" + this.getName() + ", vdc=" + this.vdc + ", description=" + this.description + ", status=" + (Object)((Object)this.status) + "]";
    }
}

