/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;

@Singleton
public class OrgNameAndCatalogNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Org>> orgMap;
    private final ReferenceType defaultOrg;
    private final ReferenceType defaultCatalog;

    @Inject
    public OrgNameAndCatalogNameToEndpoint(Supplier<Map<String, Org>> orgMap, @org.jclouds.vcloud.endpoints.Org ReferenceType defaultOrg, @Catalog ReferenceType defaultCatalog) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    public URI apply(Object from) {
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull((Object)from, (Object)"args");
        Object org = Iterables.get((Iterable)orgCatalog, (int)0);
        Object catalog = Iterables.get((Iterable)orgCatalog, (int)1);
        if (org == null && catalog == null) {
            return this.defaultCatalog.getHref();
        }
        if (org == null) {
            org = this.defaultOrg.getName();
        }
        try {
            Map<String, ReferenceType> catalogs = ((Org)Preconditions.checkNotNull(((Map)this.orgMap.get()).get(org))).getCatalogs();
            return catalog == null ? ((ReferenceType)Iterables.getLast(catalogs.values())).getHref() : catalogs.get(catalog).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + catalog + " not found in " + this.orgMap.get());
        }
    }
}

