/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.VDC;

@Singleton
public class OrgNameAndVDCNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Org>> orgNameToVDCEndpoint;
    private final ReferenceType defaultOrg;
    private final ReferenceType defaultVDC;

    @Inject
    public OrgNameAndVDCNameToEndpoint(Supplier<Map<String, Org>> orgNameToVDCEndpoint, @org.jclouds.vcloud.endpoints.Org ReferenceType defaultOrg, @VDC ReferenceType defaultVDC) {
        this.orgNameToVDCEndpoint = orgNameToVDCEndpoint;
        this.defaultOrg = defaultOrg;
        this.defaultVDC = defaultVDC;
    }

    public URI apply(Object from) {
        Iterable orgVdc = (Iterable)Preconditions.checkNotNull((Object)from, (Object)"args");
        Object org = Iterables.get((Iterable)orgVdc, (int)0);
        Object vdc = Iterables.get((Iterable)orgVdc, (int)1);
        if (org == null && vdc == null) {
            return this.defaultVDC.getHref();
        }
        if (org == null) {
            org = this.defaultOrg.getName();
        }
        try {
            Map<String, ReferenceType> vdcs = ((Org)Preconditions.checkNotNull(((Map)this.orgNameToVDCEndpoint.get()).get(org))).getVDCs();
            return vdc == null ? ((ReferenceType)Iterables.getLast(vdcs.values())).getHref() : vdcs.get(vdc).getHref();
        }
        catch (NullPointerException e) {
            throw new NoSuchElementException(org + "/" + vdc + " not found in " + this.orgNameToVDCEndpoint.get());
        }
    }
}

