/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.endpoints.Org;

public abstract class OrgNameVDCNameResourceNameToEndpoint
implements Function<Object, URI> {
    protected final Supplier<Map<String, Map<String, VDC>>> orgVDCMap;
    protected final ReferenceType defaultOrg;
    protected final ReferenceType defaultVDC;

    @Inject
    public OrgNameVDCNameResourceNameToEndpoint(Supplier<Map<String, Map<String, VDC>>> orgVDCMap, @Org ReferenceType defaultOrg, @org.jclouds.vcloud.endpoints.VDC ReferenceType defaultVDC) {
        this.orgVDCMap = orgVDCMap;
        this.defaultOrg = defaultOrg;
        this.defaultVDC = defaultVDC;
    }

    public URI apply(Object from) {
        Map orgToVDCs;
        Iterable orgVDC = (Iterable)Preconditions.checkNotNull((Object)from, (Object)"args");
        Object org = Iterables.get((Iterable)orgVDC, (int)0);
        Object vDC = Iterables.get((Iterable)orgVDC, (int)1);
        Object resource = Iterables.get((Iterable)orgVDC, (int)2);
        if (org == null) {
            org = this.defaultOrg.getName();
        }
        if (vDC == null) {
            vDC = this.defaultVDC.getName();
        }
        Preconditions.checkState(((orgToVDCs = (Map)this.orgVDCMap.get()) != null ? 1 : 0) != 0, (Object)"could not get map of org name to vdcs!");
        Map vDCs = (Map)orgToVDCs.get(org);
        if (vDCs == null) {
            throw new NoSuchElementException("org " + org + " not found in " + orgToVDCs.keySet());
        }
        VDC vDCObject = (VDC)vDCs.get(vDC);
        if (vDCObject == null) {
            throw new NoSuchElementException("vdc " + vDC + " in org " + org + " not found in " + vDCs.keySet());
        }
        return this.getEndpointOfResourceInVDC(org, vDC, resource, vDCObject);
    }

    protected abstract URI getEndpointOfResourceInVDC(Object var1, Object var2, Object var3, VDC var4);
}

