/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;
import org.xml.sax.Attributes;

public class NetworkConnectionHandler
extends ParseSax.HandlerWithResult<NetworkConnection> {
    protected StringBuilder currentText = new StringBuilder();
    protected String network;
    protected int networkConnectionIndex;
    protected String ipAddress;
    protected String externalIpAddress;
    protected boolean connected;
    protected String MACAddress;
    protected IpAddressAllocationMode ipAddressAllocationMode;

    public NetworkConnection getResult() {
        NetworkConnection connection = new NetworkConnection(this.network, this.networkConnectionIndex, this.ipAddress, this.externalIpAddress, this.connected, this.MACAddress, this.ipAddressAllocationMode);
        this.network = null;
        this.networkConnectionIndex = -1;
        this.ipAddress = null;
        this.externalIpAddress = null;
        this.connected = false;
        this.MACAddress = null;
        this.ipAddressAllocationMode = null;
        return connection;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.endsWith("NetworkConnection")) {
            this.network = (String)attributes.get("network");
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (qName.endsWith("NetworkConnectionIndex")) {
            this.networkConnectionIndex = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("IpAddress")) {
            this.ipAddress = this.currentOrNull();
        } else if (qName.endsWith("ExternalIpAddress")) {
            this.externalIpAddress = this.currentOrNull();
        } else if (qName.endsWith("IsConnected")) {
            this.connected = Boolean.parseBoolean(this.currentOrNull());
        } else if (qName.endsWith("MACAddress")) {
            this.MACAddress = this.currentOrNull();
        } else if (qName.endsWith("IpAddressAllocationMode")) {
            this.ipAddressAllocationMode = IpAddressAllocationMode.valueOf(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

