/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.karaf.admin.AdminService;
import org.apache.karaf.admin.Instance;
import org.apache.karaf.admin.InstanceSettings;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminPlugin
extends AbstractWebConsolePlugin {
    private final Logger logger = LoggerFactory.getLogger(AdminPlugin.class);
    public static final String NAME = "admin";
    public static final String LABEL = "Admin";
    private String adminJs = "/admin/res/ui/admin.js";
    private BundleContext bundleContext;
    private AdminService adminService;
    private ClassLoader classLoader;

    public void start() {
        super.activate(this.bundleContext);
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.logger.info("Admin plugin activated");
    }

    public void stop() {
        this.logger.info("Admin plugin deactivated");
        super.deactivate();
    }

    public String getTitle() {
        return LABEL;
    }

    public String getLabel() {
        return NAME;
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        String appRoot = (String)req.getAttribute("org.apache.felix.webconsole.internal.servlet.OsgiManager.appRoot");
        String adminScriptTag = "<script src='" + appRoot + this.adminJs + "' language='JavaScript'></script>";
        pw.println(adminScriptTag);
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.println("var imgRoot = '" + appRoot + "/res/imgs';");
        pw.println("// ]]>");
        pw.println("</script>");
        pw.println("<div id='plugin_content'/>");
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.print("renderAdmin( ");
        this.writeJSON(pw);
        pw.println(" )");
        pw.println("// ]]>");
        pw.println("</script>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean success = false;
        String action = req.getParameter("action");
        String name = req.getParameter("name");
        if (action == null) {
            success = true;
        } else if ("create".equals(action)) {
            int sshPort = this.parsePortNumber(req.getParameter("sshPort"));
            int rmiRegistryPort = this.parsePortNumber(req.getParameter("rmiRegistryPort"));
            int rmiServerPort = this.parsePortNumber(req.getParameter("rmiServerPort"));
            String location = this.parseString(req.getParameter("location"));
            String javaOpts = this.parseString(req.getParameter("javaOpts"));
            List<String> featureURLs = this.parseStringList(req.getParameter("featureURLs"));
            List<String> features = this.parseStringList(req.getParameter("features"));
            InstanceSettings settings = new InstanceSettings(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, featureURLs, features);
            success = this.createInstance(name, settings);
        } else if ("destroy".equals(action)) {
            success = this.destroyInstance(name);
        } else if ("start".equals(action)) {
            String javaOpts = req.getParameter("javaOpts");
            success = this.startInstance(name, javaOpts);
        } else if ("stop".equals(action)) {
            success = this.stopInstance(name);
        }
        if (success) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.renderJSON(res, null);
        } else {
            super.doPost(req, res);
        }
    }

    private String parseString(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        return value;
    }

    private List<String> parseStringList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (String el : value.split(",")) {
                String trimmed = el.trim();
                if (trimmed.length() == 0) continue;
                list.add(trimmed);
            }
        }
        return list;
    }

    private int parsePortNumber(String port) {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String path) {
        URL url = this.classLoader.getResource(path = path.substring(NAME.length() + 1));
        if (url != null) {
            InputStream ins = null;
            try {
                ins = url.openStream();
                if (ins == null) {
                    this.logger.error("failed to open " + url);
                    url = null;
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                url = null;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return url;
    }

    private void renderJSON(HttpServletResponse response, String feature) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw);
    }

    private void writeJSON(PrintWriter pw) {
        JSONWriter jw = new JSONWriter((Writer)pw);
        Instance[] instances = this.adminService.getInstances();
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)this.getStatusLine());
            jw.key("instances");
            jw.array();
            for (Instance i : instances) {
                this.instanceInfo(jw, i);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException ex) {
            java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void instanceInfo(JSONWriter jw, Instance instance) throws JSONException, Exception {
        jw.object();
        jw.key("pid");
        jw.value((long)instance.getPid());
        jw.key("name");
        jw.value((Object)instance.getName());
        jw.key("sshPort");
        jw.value((long)instance.getSshPort());
        jw.key("rmiRegistryPort");
        jw.value((long)instance.getRmiRegistryPort());
        jw.key("rmiServerPort");
        jw.value((long)instance.getRmiServerPort());
        jw.key("state");
        jw.value((Object)instance.getState());
        jw.key("location");
        jw.value((Object)(instance.getJavaOpts() != null ? instance.getJavaOpts() : ""));
        jw.key("javaopts");
        jw.value((Object)instance.getLocation());
        jw.key("actions");
        jw.array();
        this.action(jw, "destroy", "Destroy", "delete");
        if (instance.getState().equals("Started")) {
            this.action(jw, "stop", "Stop", "stop");
        } else if (instance.getState().equals("Starting")) {
            this.action(jw, "stop", "Stop", "stop");
        } else if (instance.getState().equals("Stopped")) {
            this.action(jw, "start", "Start", "start");
        }
        jw.endArray();
        jw.endObject();
    }

    private void action(JSONWriter jw, String op, String title, String image) throws JSONException {
        jw.object();
        jw.key("op").value((Object)op);
        jw.key("title").value((Object)title);
        jw.key("image").value((Object)image);
        jw.endObject();
    }

    private String getStatusLine() {
        Instance[] instances = this.adminService.getInstances();
        int started = 0;
        int starting = 0;
        int stopped = 0;
        for (Instance instance : instances) {
            try {
                if (instance.getState().equals("Started")) {
                    ++started;
                    continue;
                }
                if (instance.getState().equals("Starting")) {
                    ++starting;
                    continue;
                }
                if (!instance.getState().equals("Stopped")) continue;
                ++stopped;
            }
            catch (Exception ex) {
                java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Instance information: ");
        buffer.append(instances.length);
        buffer.append(" instance");
        if (instances.length != 1) {
            buffer.append('s');
        }
        buffer.append(" in total");
        if (started == instances.length) {
            buffer.append(" - all started");
        } else {
            if (started != 0) {
                buffer.append(", ");
                buffer.append(started);
                buffer.append(" started");
            }
            if (starting != 0) {
                buffer.append(", ");
                buffer.append(starting);
                buffer.append(" starting");
            }
            buffer.append('.');
        }
        return buffer.toString();
    }

    private boolean createInstance(String name, InstanceSettings settings) {
        try {
            this.adminService.createInstance(name, settings);
            return true;
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private boolean destroyInstance(String name) {
        try {
            Instance instance = this.adminService.getInstance(name);
            if (instance != null) {
                instance.destroy();
                return true;
            }
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private boolean startInstance(String name, String javaOpts) {
        try {
            Instance instance = this.adminService.getInstance(name);
            if (instance != null) {
                instance.start(javaOpts);
                return true;
            }
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private boolean stopInstance(String name) {
        try {
            Instance instance = this.adminService.getInstance(name);
            if (instance != null) {
                instance.stop();
                return true;
            }
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(AdminPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

