/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.aggregator.SequenceNumberComparator;
import org.springframework.integration.aggregator.SequenceSizeReleaseStrategy;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupCallback;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.integration.util.DefaultLockRegistry;
import org.springframework.integration.util.LockRegistry;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCorrelatingMessageHandler
extends AbstractMessageHandler
implements MessageProducer {
    private static final Log logger = LogFactory.getLog(AbstractCorrelatingMessageHandler.class);
    public static final long DEFAULT_SEND_TIMEOUT = 1000L;
    protected volatile MessageGroupStore messageStore;
    private final MessageGroupProcessor outputProcessor;
    private volatile CorrelationStrategy correlationStrategy;
    private volatile ReleaseStrategy releaseStrategy;
    private MessageChannel outputChannel;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private volatile MessageChannel discardChannel = new NullChannel();
    private boolean sendPartialResultOnExpiry = false;
    private volatile boolean sequenceAware = false;
    private volatile LockRegistry lockRegistry = new DefaultLockRegistry();
    private boolean lockRegistrySet = false;

    public AbstractCorrelatingMessageHandler(MessageGroupProcessor processor, MessageGroupStore store, CorrelationStrategy correlationStrategy, ReleaseStrategy releaseStrategy) {
        Assert.notNull((Object)processor);
        Assert.notNull((Object)store);
        this.setMessageStore(store);
        this.outputProcessor = processor;
        this.correlationStrategy = correlationStrategy == null ? new HeaderAttributeCorrelationStrategy("correlationId") : correlationStrategy;
        this.releaseStrategy = releaseStrategy == null ? new SequenceSizeReleaseStrategy() : releaseStrategy;
        this.messagingTemplate.setSendTimeout(1000L);
        this.sequenceAware = this.releaseStrategy instanceof SequenceSizeReleaseStrategy;
    }

    public AbstractCorrelatingMessageHandler(MessageGroupProcessor processor, MessageGroupStore store) {
        this(processor, store, null, null);
    }

    public AbstractCorrelatingMessageHandler(MessageGroupProcessor processor) {
        this(processor, new SimpleMessageStore(0), null, null);
    }

    public void setLockRegistry(LockRegistry lockRegistry) {
        Assert.isTrue((!this.lockRegistrySet ? 1 : 0) != 0, (String)"'this.lockRegistry' can not be reset once its been set");
        Assert.notNull((Object)"'lockRegistry' must not be null");
        this.lockRegistry = lockRegistry;
        this.lockRegistrySet = true;
    }

    public void setMessageStore(MessageGroupStore store) {
        this.messageStore = store;
        store.registerMessageGroupExpiryCallback(new MessageGroupCallback(){

            public void execute(MessageGroupStore messageGroupStore, MessageGroup group) {
                AbstractCorrelatingMessageHandler.this.forceComplete(group);
            }
        });
    }

    public void setCorrelationStrategy(CorrelationStrategy correlationStrategy) {
        Assert.notNull((Object)correlationStrategy);
        this.correlationStrategy = correlationStrategy;
    }

    public void setReleaseStrategy(ReleaseStrategy releaseStrategy) {
        Assert.notNull((Object)releaseStrategy);
        this.releaseStrategy = releaseStrategy;
        this.sequenceAware = this.releaseStrategy instanceof SequenceSizeReleaseStrategy;
    }

    @Override
    public void setOutputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"'outputChannel' must not be null");
        this.outputChannel = outputChannel;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory != null) {
            this.messagingTemplate.setBeanFactory(beanFactory);
        }
    }

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.messagingTemplate.setSendTimeout(sendTimeout);
    }

    public void setSendPartialResultOnExpiry(boolean sendPartialResultOnExpiry) {
        this.sendPartialResultOnExpiry = sendPartialResultOnExpiry;
    }

    public void setReleasePartialSequences(boolean releasePartialSequences) {
        Assert.isInstanceOf(SequenceSizeReleaseStrategy.class, (Object)this.releaseStrategy, (String)("Release strategy of type [" + this.releaseStrategy.getClass().getSimpleName() + "] cannot release partial sequences. Use the default SequenceSizeReleaseStrategy instead."));
        ((SequenceSizeReleaseStrategy)this.releaseStrategy).setReleasePartialSequences(releasePartialSequences);
    }

    @Override
    public String getComponentType() {
        return "aggregator";
    }

    protected MessageGroupStore getMessageStore() {
        return this.messageStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        block10: {
            Object correlationKey = this.correlationStrategy.getCorrelationKey(message);
            Assert.state((correlationKey != null ? 1 : 0) != 0, (String)"Null correlation not allowed.  Maybe the CorrelationStrategy is failing?");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Handling message with correlationKey [" + correlationKey + "]: " + message));
            }
            Lock lock = this.lockRegistry.obtain(correlationKey);
            lock.lockInterruptibly();
            try {
                MessageGroup messageGroup = this.messageStore.getMessageGroup(correlationKey);
                if (this.sequenceAware) {
                    messageGroup = new SequenceAwareMessageGroup(messageGroup);
                }
                if (!messageGroup.isComplete() && messageGroup.canAdd(message)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Adding message to group [ " + messageGroup + "]"));
                    }
                    if (!this.releaseStrategy.canRelease(messageGroup = this.store(correlationKey, message))) break block10;
                    Collection<Message<?>> completedMessages = null;
                    try {
                        completedMessages = this.completeGroup(message, correlationKey, messageGroup);
                        break block10;
                    }
                    finally {
                        this.afterRelease(messageGroup, completedMessages);
                    }
                }
                this.discardChannel.send(message);
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected abstract void afterRelease(MessageGroup var1, Collection<Message<?>> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean forceComplete(MessageGroup group) {
        Object correlationKey = group.getGroupId();
        Lock lock = this.lockRegistry.obtain(correlationKey);
        try {
            lock.lockInterruptibly();
            try {
                if (group.size() <= 0) return false;
                try {
                    if (this.releaseStrategy.canRelease(group)) {
                        this.completeGroup(correlationKey, group);
                    } else {
                        this.expireGroup(correlationKey, group);
                    }
                }
                finally {
                    this.remove(group);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new MessagingException("Thread was interrupted while trying to obtain lock");
        }
    }

    void remove(MessageGroup group) {
        Object correlationKey = group.getGroupId();
        this.messageStore.removeMessageGroup(correlationKey);
    }

    protected int findLastReleasedSequenceNumber(Object groupId, Collection<Message<?>> partialSequence) {
        ArrayList sorted = new ArrayList(partialSequence);
        Collections.sort(sorted, new SequenceNumberComparator());
        Message lastReleasedMessage = (Message)sorted.get(partialSequence.size() - 1);
        return lastReleasedMessage.getHeaders().getSequenceNumber();
    }

    private MessageGroup store(Object correlationKey, Message<?> message) {
        return this.messageStore.addMessageToGroup(correlationKey, message);
    }

    private void expireGroup(Object correlationKey, MessageGroup group) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Expiring MessageGroup with correlationKey[" + correlationKey + "]"));
        }
        if (this.sendPartialResultOnExpiry) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Prematurely releasing partially complete group with key [" + correlationKey + "] to: " + this.outputChannel));
            }
            this.completeGroup(correlationKey, group);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Discarding messages of partially complete group with key [" + correlationKey + "] to: " + this.discardChannel));
            }
            for (Message<?> message : group.getMessages()) {
                this.discardChannel.send(message);
            }
        }
    }

    private void completeGroup(Object correlationKey, MessageGroup group) {
        Message<?> first = null;
        if (group != null) {
            first = group.getOne();
        }
        this.completeGroup(first, correlationKey, group);
    }

    private Collection<Message<?>> completeGroup(Message<?> message, Object correlationKey, MessageGroup group) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completing group with correlationKey [" + correlationKey + "]"));
        }
        Object result = this.outputProcessor.processMessageGroup(group);
        Collection partialSequence = null;
        if (result instanceof Collection) {
            this.verifyResultCollectionConsistsOfMessages((Collection)result);
            partialSequence = (Collection)result;
        }
        this.sendReplies(result, message);
        return partialSequence;
    }

    private void verifyResultCollectionConsistsOfMessages(Collection<?> elements) {
        Class commonElementType = CollectionUtils.findCommonElementType(elements);
        Assert.isAssignable(Message.class, (Class)commonElementType, (String)("The expected collection of Messages contains non-Message element: " + commonElementType));
    }

    private void sendReplies(Object processorResult, Message message) {
        Object replyChannelHeader = null;
        if (message != null) {
            replyChannelHeader = message.getHeaders().getReplyChannel();
        }
        Object replyChannel = this.outputChannel;
        if (this.outputChannel == null) {
            replyChannel = replyChannelHeader;
        }
        Assert.notNull((Object)replyChannel, (String)"no outputChannel or replyChannel header available");
        if (processorResult instanceof Iterable && this.shouldSendMultipleReplies((Iterable)processorResult)) {
            for (Object next : (Iterable)processorResult) {
                this.sendReplyMessage(next, replyChannel);
            }
        } else {
            this.sendReplyMessage(processorResult, replyChannel);
        }
    }

    private void sendReplyMessage(Object reply, Object replyChannel) {
        if (replyChannel instanceof MessageChannel) {
            if (reply instanceof Message) {
                this.messagingTemplate.send((MessageChannel)replyChannel, (Message)reply);
            } else {
                this.messagingTemplate.convertAndSend((MessageChannel)replyChannel, reply);
            }
        } else if (replyChannel instanceof String) {
            if (reply instanceof Message) {
                this.messagingTemplate.send((String)replyChannel, (Message)reply);
            } else {
                this.messagingTemplate.convertAndSend((String)replyChannel, reply);
            }
        } else {
            throw new MessagingException("replyChannel must be a MessageChannel or String");
        }
    }

    private boolean shouldSendMultipleReplies(Iterable<?> iter) {
        for (Object next : iter) {
            if (!(next instanceof Message)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceAwareMessageGroup
    extends SimpleMessageGroup {
        public SequenceAwareMessageGroup(MessageGroup messageGroup) {
            super(messageGroup);
        }

        @Override
        public boolean canAdd(Message<?> message) {
            if (this.size() == 0) {
                return true;
            }
            Integer messageSequenceNumber = message.getHeaders().getSequenceNumber();
            if (messageSequenceNumber != null && messageSequenceNumber > 0) {
                Integer messageSequenceSize = message.getHeaders().getSequenceSize();
                if (!messageSequenceSize.equals(this.getSequenceSize())) {
                    return false;
                }
                return !this.containsSequenceNumber(this.getMessages(), messageSequenceNumber);
            }
            return true;
        }

        private boolean containsSequenceNumber(Collection<Message<?>> messages, Integer messageSequenceNumber) {
            for (Message<?> member : messages) {
                Integer memberSequenceNumber = member.getHeaders().getSequenceNumber();
                if (!messageSequenceNumber.equals(memberSequenceNumber)) continue;
                return true;
            }
            return false;
        }
    }
}

