/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.integration.Message;
import org.springframework.integration.aggregator.AbstractCorrelatingMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingMessageHandler
extends AbstractCorrelatingMessageHandler {
    private volatile boolean expireGroupsUponCompletion = false;

    public AggregatingMessageHandler(MessageGroupProcessor processor, MessageGroupStore store, CorrelationStrategy correlationStrategy, ReleaseStrategy releaseStrategy) {
        super(processor, store, correlationStrategy, releaseStrategy);
    }

    public AggregatingMessageHandler(MessageGroupProcessor processor, MessageGroupStore store) {
        super(processor, store);
    }

    public AggregatingMessageHandler(MessageGroupProcessor processor) {
        super(processor);
    }

    public void setExpireGroupsUponCompletion(boolean expireGroupsUponCompletion) {
        this.expireGroupsUponCompletion = expireGroupsUponCompletion;
        if (expireGroupsUponCompletion) {
            Iterator<MessageGroup> messageGroups = this.messageStore.iterator();
            while (messageGroups.hasNext()) {
                MessageGroup messageGroup = messageGroups.next();
                if (!messageGroup.isComplete()) continue;
                this.remove(messageGroup);
            }
        }
    }

    @Override
    protected void afterRelease(MessageGroup messageGroup, Collection<Message<?>> completedMessages) {
        this.messageStore.completeGroup(messageGroup.getGroupId());
        if (this.expireGroupsUponCompletion) {
            this.remove(messageGroup);
        } else {
            for (Message<?> message : messageGroup.getMessages()) {
                this.messageStore.removeMessageFromGroup(messageGroup.getGroupId(), message);
            }
        }
    }
}

