/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.MessagingException;
import org.springframework.integration.message.ErrorMessage;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class MessagePublishingErrorHandler
implements ErrorHandler,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile ChannelResolver channelResolver;
    private volatile MessageChannel defaultErrorChannel;
    private volatile long sendTimeout = 1000L;

    public MessagePublishingErrorHandler() {
    }

    public MessagePublishingErrorHandler(ChannelResolver channelResolver) {
        Assert.notNull((Object)channelResolver, (String)"channelResolver must not be null");
        this.channelResolver = channelResolver;
    }

    public void setDefaultErrorChannel(MessageChannel defaultErrorChannel) {
        this.defaultErrorChannel = defaultErrorChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        if (this.channelResolver == null) {
            this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
        }
    }

    public final void handleError(Throwable t) {
        boolean sent;
        block6: {
            MessageChannel errorChannel = this.resolveErrorChannel(t);
            sent = false;
            if (errorChannel != null) {
                try {
                    sent = this.sendTimeout >= 0L ? errorChannel.send(new ErrorMessage(t), this.sendTimeout) : errorChannel.send(new ErrorMessage(t));
                }
                catch (Throwable errorDeliveryError) {
                    if (!this.logger.isWarnEnabled()) break block6;
                    this.logger.warn((Object)"Error message was not delivered.", errorDeliveryError);
                }
            }
        }
        if (!sent && this.logger.isErrorEnabled()) {
            Message<?> failedMessage;
            Message<?> message = failedMessage = t instanceof MessagingException ? ((MessagingException)t).getFailedMessage() : null;
            if (failedMessage != null) {
                this.logger.error((Object)("failure occurred in messaging task with message: " + failedMessage), t);
            } else {
                this.logger.error((Object)"failure occurred in messaging task", t);
            }
        }
    }

    private MessageChannel resolveErrorChannel(Throwable t) {
        Message<?> failedMessage;
        Message<?> message = failedMessage = t instanceof MessagingException ? ((MessagingException)t).getFailedMessage() : null;
        if (this.defaultErrorChannel == null && this.channelResolver != null) {
            this.defaultErrorChannel = this.channelResolver.resolveChannelName("errorChannel");
        }
        if (failedMessage == null || failedMessage.getHeaders().getErrorChannel() == null) {
            return this.defaultErrorChannel;
        }
        Object errorChannelHeader = failedMessage.getHeaders().getErrorChannel();
        if (errorChannelHeader instanceof MessageChannel) {
            return (MessageChannel)errorChannelHeader;
        }
        Assert.isInstanceOf(String.class, (Object)errorChannelHeader, (String)("Unsupported error channel header type. Expected MessageChannel or String, but actual type is [" + errorChannelHeader.getClass() + "]"));
        return this.channelResolver.resolveChannelName((String)errorChannelHeader);
    }
}

