/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.MessageProducer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleMessageHandlerFactoryBean<H extends MessageHandler>
implements FactoryBean<MessageHandler>,
BeanFactoryAware {
    private volatile H handler;
    private volatile MessageChannel outputChannel;
    private volatile Integer order;
    private BeanFactory beanFactory;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public H getObject() throws Exception {
        if (this.handler == null) {
            this.handler = this.createHandlerInternal();
            Assert.notNull(this.handler, (String)"failed to create MessageHandler");
            if (this.handler instanceof MessageProducer && this.outputChannel != null) {
                ((MessageProducer)this.handler).setOutputChannel(this.outputChannel);
            }
            if (this.handler instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.handler).setBeanFactory(this.beanFactory);
            }
            if (this.handler instanceof Orderable && this.order != null) {
                ((Orderable)this.handler).setOrder(this.order);
            }
        }
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final H createHandlerInternal() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return null;
            }
            this.handler = this.createHandler();
            if (this.handler instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.handler).setBeanFactory(this.getBeanFactory());
            }
            this.initialized = true;
        }
        if (this.handler instanceof InitializingBean) {
            try {
                ((InitializingBean)this.handler).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanInitializationException("failed to initialize MessageHandler", (Throwable)e);
            }
        }
        return this.handler;
    }

    protected abstract H createHandler();

    public Class<? extends MessageHandler> getObjectType() {
        if (this.handler != null) {
            return this.handler.getClass();
        }
        return MessageHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

