/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Method;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MethodInvokingCorrelationStrategy;
import org.springframework.integration.config.AnnotationFinder;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationStrategyFactoryBean
implements FactoryBean<CorrelationStrategy> {
    private CorrelationStrategy delegate = new HeaderAttributeCorrelationStrategy("correlationId");

    public CorrelationStrategyFactoryBean(Object target) {
        this(target, null);
    }

    public CorrelationStrategyFactoryBean(Object target, String methodName) {
        if (target instanceof CorrelationStrategy && !StringUtils.hasText((String)methodName)) {
            this.delegate = (CorrelationStrategy)target;
            return;
        }
        if (target != null) {
            if (StringUtils.hasText((String)methodName)) {
                this.delegate = new MethodInvokingCorrelationStrategy(target, methodName);
            } else {
                Method method = AnnotationFinder.findAnnotatedMethod(target, org.springframework.integration.annotation.CorrelationStrategy.class);
                if (method != null) {
                    this.delegate = new MethodInvokingCorrelationStrategy(target, method);
                }
            }
        }
    }

    public CorrelationStrategy getObject() throws Exception {
        return this.delegate;
    }

    public Class<?> getObjectType() {
        return CorrelationStrategy.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

