/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.expression.Expression;
import org.springframework.integration.config.AbstractStandardMessageHandlerFactoryBean;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceActivatorFactoryBean
extends AbstractStandardMessageHandlerFactoryBean {
    private volatile Long sendTimeout;
    private volatile Boolean requiresReply;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    @Override
    MessageHandler createMethodInvokingHandler(Object targetObject, String targetMethodName) {
        ServiceActivatingHandler handler = StringUtils.hasText((String)targetMethodName) ? new ServiceActivatingHandler(targetObject, targetMethodName) : new ServiceActivatingHandler(targetObject);
        return this.configureHandler(handler);
    }

    @Override
    MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        ExpressionEvaluatingMessageProcessor processor = new ExpressionEvaluatingMessageProcessor(expression);
        processor.setBeanFactory(this.getBeanFactory());
        return this.configureHandler(new ServiceActivatingHandler(processor));
    }

    @Override
    <T> MessageHandler createMessageProcessingHandler(MessageProcessor<T> processor) {
        return this.configureHandler(new ServiceActivatingHandler(processor));
    }

    private ServiceActivatingHandler configureHandler(ServiceActivatingHandler handler) {
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        if (this.requiresReply != null) {
            handler.setRequiresReply(this.requiresReply);
        }
        return handler;
    }
}

