/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodAnnotationPostProcessor<T extends Annotation>
implements MethodAnnotationPostProcessor<T> {
    private static final String INPUT_CHANNEL_ATTRIBUTE = "inputChannel";
    protected final BeanFactory beanFactory;
    protected final ChannelResolver channelResolver;

    public AbstractMethodAnnotationPostProcessor(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
        this.channelResolver = new BeanFactoryChannelResolver((BeanFactory)beanFactory);
    }

    @Override
    public Object postProcess(Object bean, String beanName, Method method, T annotation) {
        AbstractEndpoint endpoint;
        Order orderAnnotation;
        MessageHandler handler = this.createHandler(bean, method, annotation);
        if (handler instanceof Orderable && (orderAnnotation = (Order)AnnotationUtils.findAnnotation((Method)method, Order.class)) != null) {
            ((Orderable)((Object)handler)).setOrder(orderAnnotation.value());
        }
        if (this.beanFactory instanceof ConfigurableListableBeanFactory) {
            handler = (MessageHandler)((ConfigurableListableBeanFactory)this.beanFactory).initializeBean((Object)handler, "_initHandlerFor_" + beanName);
        }
        if ((endpoint = this.createEndpoint(handler, annotation)) != null) {
            return endpoint;
        }
        return handler;
    }

    protected boolean shouldCreateEndpoint(T annotation) {
        return StringUtils.hasText((String)((String)AnnotationUtils.getValue(annotation, (String)INPUT_CHANNEL_ATTRIBUTE)));
    }

    private AbstractEndpoint createEndpoint(MessageHandler handler, T annotation) {
        EventDrivenConsumer endpoint = null;
        String inputChannelName = (String)AnnotationUtils.getValue(annotation, (String)INPUT_CHANNEL_ATTRIBUTE);
        if (StringUtils.hasText((String)inputChannelName)) {
            MessageChannel inputChannel = this.channelResolver.resolveChannelName(inputChannelName);
            Assert.notNull((Object)inputChannel, (String)("failed to resolve inputChannel '" + inputChannelName + "'"));
            Assert.isTrue((boolean)(inputChannel instanceof SubscribableChannel), (String)"The input channel for an Annotation-based endpoint must be a SubscribableChannel.");
            endpoint = new EventDrivenConsumer((SubscribableChannel)inputChannel, handler);
            if (handler instanceof BeanFactoryAware) {
                ((BeanFactoryAware)handler).setBeanFactory(this.beanFactory);
            }
        }
        return endpoint;
    }

    protected abstract MessageHandler createHandler(Object var1, Method var2, T var3);
}

