/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.reflect.Method;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.filter.MessageFilter;
import org.springframework.integration.filter.MethodInvokingSelector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Filter> {
    public FilterAnnotationPostProcessor(ListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, Filter annotation) {
        Assert.isTrue((Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType()) ? 1 : 0) != 0, (String)"The Filter annotation may only be applied to methods with a boolean return type.");
        MethodInvokingSelector selector = new MethodInvokingSelector(bean, method);
        MessageFilter filter = new MessageFilter(selector);
        String outputChannelName = annotation.outputChannel();
        if (StringUtils.hasText((String)outputChannelName)) {
            filter.setOutputChannel(this.channelResolver.resolveChannelName(outputChannelName));
        }
        return filter;
    }
}

