/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.annotation.AggregatorAnnotationPostProcessor;
import org.springframework.integration.config.annotation.FilterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.config.annotation.RouterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.ServiceActivatorAnnotationPostProcessor;
import org.springframework.integration.config.annotation.SplitterAnnotationPostProcessor;
import org.springframework.integration.config.annotation.TransformerAnnotationPostProcessor;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagingAnnotationPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
Lifecycle,
ApplicationListener<ApplicationEvent> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile ConfigurableListableBeanFactory beanFactory;
    private final Map<Class<? extends Annotation>, MethodAnnotationPostProcessor<?>> postProcessors = new HashMap();
    private final Set<ApplicationListener<ApplicationEvent>> listeners = new HashSet<ApplicationListener<ApplicationEvent>>();
    private final Set<Lifecycle> lifecycles = new HashSet<Lifecycle>();
    private volatile boolean running = true;

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        this.postProcessors.put(Filter.class, new FilterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(Router.class, new RouterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(Transformer.class, new TransformerAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(ServiceActivator.class, new ServiceActivatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(Splitter.class, new SplitterAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
        this.postProcessors.put(Aggregator.class, new AggregatorAnnotationPostProcessor((ListableBeanFactory)this.beanFactory));
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, final String beanName) throws BeansException {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        Class<?> beanClass = this.getBeanClass(bean);
        if (!this.isStereotype(beanClass)) {
            return bean;
        }
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Annotation[] annotations;
                for (Annotation annotation : annotations = AnnotationUtils.getAnnotations((Method)method)) {
                    Object result;
                    MethodAnnotationPostProcessor postProcessor = (MethodAnnotationPostProcessor)MessagingAnnotationPostProcessor.this.postProcessors.get(annotation.annotationType());
                    if (postProcessor == null || !MessagingAnnotationPostProcessor.this.shouldCreateEndpoint(annotation) || (result = postProcessor.postProcess(bean, beanName, method, annotation)) == null || !(result instanceof AbstractEndpoint)) continue;
                    String endpointBeanName = MessagingAnnotationPostProcessor.this.generateBeanName(beanName, method, annotation.annotationType());
                    if (result instanceof BeanNameAware) {
                        ((BeanNameAware)result).setBeanName(endpointBeanName);
                    }
                    MessagingAnnotationPostProcessor.this.beanFactory.registerSingleton(endpointBeanName, result);
                    if (result instanceof BeanFactoryAware) {
                        ((BeanFactoryAware)result).setBeanFactory((BeanFactory)MessagingAnnotationPostProcessor.this.beanFactory);
                    }
                    if (result instanceof InitializingBean) {
                        try {
                            ((InitializingBean)result).afterPropertiesSet();
                        }
                        catch (Exception e) {
                            throw new BeanInitializationException("failed to initialize annotated component", (Throwable)e);
                        }
                    }
                    if (result instanceof Lifecycle) {
                        MessagingAnnotationPostProcessor.this.lifecycles.add((Lifecycle)result);
                        if (result instanceof SmartLifecycle && ((SmartLifecycle)result).isAutoStartup()) {
                            ((SmartLifecycle)result).start();
                        }
                    }
                    if (!(result instanceof ApplicationListener)) continue;
                    MessagingAnnotationPostProcessor.this.listeners.add((ApplicationListener)result);
                }
            }
        });
        return bean;
    }

    private boolean shouldCreateEndpoint(Annotation annotation) {
        Object inputChannel = AnnotationUtils.getValue((Annotation)annotation, (String)"inputChannel");
        return inputChannel != null && inputChannel instanceof String && StringUtils.hasText((String)((String)inputChannel));
    }

    private Class<?> getBeanClass(Object bean) {
        Class<?> targetClass = AopUtils.getTargetClass((Object)bean);
        return targetClass != null ? targetClass : bean.getClass();
    }

    private boolean isStereotype(Class<?> beanClass) {
        Class<?>[] interfaces;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(Arrays.asList(beanClass.getAnnotations()));
        for (Class<?> iface : interfaces = beanClass.getInterfaces()) {
            annotations.addAll(Arrays.asList(iface.getAnnotations()));
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.equals(Component.class) && !annotationType.isAnnotationPresent(Component.class)) continue;
            return true;
        }
        return false;
    }

    private String generateBeanName(String originalBeanName, Method method, Class<? extends Annotation> annotationType) {
        String baseName;
        String name = baseName = originalBeanName + "." + method.getName() + "." + ClassUtils.getShortNameAsProperty(annotationType);
        int count = 1;
        while (this.beanFactory.containsBean(name)) {
            name = baseName + "#" + ++count;
        }
        return name;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        for (ApplicationListener<ApplicationEvent> listener : this.listeners) {
            try {
                listener.onApplicationEvent(event);
            }
            catch (ClassCastException e) {
                if (!this.logger.isWarnEnabled() || event == null) continue;
                this.logger.warn((Object)("ApplicationEvent of type [" + event.getClass() + "] not accepted by ApplicationListener [" + listener + "]"));
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        for (Lifecycle lifecycle : this.lifecycles) {
            if (lifecycle.isRunning()) continue;
            lifecycle.start();
        }
        this.running = true;
    }

    public void stop() {
        for (Lifecycle lifecycle : this.lifecycles) {
            if (!lifecycle.isRunning()) continue;
            lifecycle.stop();
        }
        this.running = false;
    }
}

