/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.reflect.Method;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.config.annotation.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.router.MethodInvokingRouter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Router> {
    public RouterAnnotationPostProcessor(ListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, Router annotation) {
        MethodInvokingRouter router = new MethodInvokingRouter(bean, method);
        router.setBeanFactory(this.beanFactory);
        String defaultOutputChannelName = annotation.defaultOutputChannel();
        if (StringUtils.hasText((String)defaultOutputChannelName)) {
            MessageChannel defaultOutputChannel = this.channelResolver.resolveChannelName(defaultOutputChannelName);
            Assert.notNull((Object)defaultOutputChannel, (String)("unable to resolve defaultOutputChannel '" + defaultOutputChannelName + "'"));
            router.setDefaultOutputChannel(defaultOutputChannel);
        }
        return router;
    }
}

