/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.ChannelInterceptorParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractChannelParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String datatypeAttr;
        BeanDefinitionBuilder builder = this.buildBeanDefinition(element, parserContext);
        ManagedList interceptors = null;
        Element interceptorsElement = DomUtils.getChildElementByTagName((Element)element, (String)"interceptors");
        if (interceptorsElement != null) {
            ChannelInterceptorParser interceptorParser = new ChannelInterceptorParser();
            interceptors = interceptorParser.parseInterceptors(interceptorsElement, parserContext);
        }
        if (interceptors == null) {
            interceptors = new ManagedList();
        }
        if (StringUtils.hasText((String)(datatypeAttr = element.getAttribute("datatype")))) {
            builder.addPropertyValue("datatypes", (Object)datatypeAttr);
        }
        builder.addPropertyValue("interceptors", (Object)interceptors);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String scopeAttr = element.getAttribute("scope");
        if (StringUtils.hasText((String)scopeAttr)) {
            builder.setScope(scopeAttr);
        }
        beanDefinition.setSource(parserContext.extractSource((Object)element));
        return beanDefinition;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        String scope = definition.getBeanDefinition().getScope();
        if (!("".equals(scope) || "singleton".equals(scope) || "prototype".equals(scope))) {
            definition = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definition, (BeanDefinitionRegistry)registry, (boolean)false);
        }
        super.registerBeanDefinition(definition, registry);
    }

    protected abstract BeanDefinitionBuilder buildBeanDefinition(Element var1, ParserContext var2);
}

