/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractOutboundChannelAdapterParser
extends AbstractChannelAdapterParser {
    protected AbstractBeanDefinition doParse(Element element, ParserContext parserContext, String channelName) {
        Element pollerElement = DomUtils.getChildElementByTagName((Element)element, (String)"poller");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.config.ConsumerEndpointFactoryBean");
        builder.addPropertyReference("handler", this.parseAndRegisterConsumer(element, parserContext));
        if (pollerElement != null) {
            if (!StringUtils.hasText((String)channelName)) {
                parserContext.getReaderContext().error("outbound channel adapter with a 'poller' requires a 'channel' to poll", (Object)element);
            }
            IntegrationNamespaceUtils.configurePollerMetadata(pollerElement, builder, parserContext);
        }
        builder.addPropertyValue("inputChannelName", (Object)channelName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "auto-startup");
        return builder.getBeanDefinition();
    }

    protected String parseAndRegisterConsumer(Element element, ParserContext parserContext) {
        String order;
        AbstractBeanDefinition definition = this.parseConsumer(element, parserContext);
        if (definition == null) {
            parserContext.getReaderContext().error("Consumer parsing must return a BeanComponentDefinition.", (Object)element);
        }
        if (StringUtils.hasText((String)(order = element.getAttribute("order")))) {
            definition.getPropertyValues().addPropertyValue("order", (Object)order);
        }
        String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)parserContext.getRegistry());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)definition, beanName));
        return beanName;
    }

    protected abstract AbstractBeanDefinition parseConsumer(Element var1, ParserContext var2);
}

