/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.ExpressionEvaluatingMessageGroupProcessor;
import org.springframework.integration.aggregator.MethodInvokingMessageGroupProcessor;
import org.springframework.integration.config.xml.AbstractCorrelatingMessageHandlerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AggregatorParser
extends AbstractCorrelatingMessageHandlerParser {
    private static final String RELEASE_STRATEGY_REF_ATTRIBUTE = "release-strategy";
    private static final String RELEASE_STRATEGY_METHOD_ATTRIBUTE = "release-strategy-method";
    private static final String RELEASE_STRATEGY_EXPRESSION_ATTRIBUTE = "release-strategy-expression";
    private static final String RELEASE_STRATEGY_PROPERTY = "releaseStrategy";
    private static final String EXPIRE_GROUPS_UPON_COMPLETION = "expire-groups-upon-completion";

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanComponentDefinition innerHandlerDefinition = IntegrationNamespaceUtils.parseInnerHandlerDefinition(element, parserContext);
        String ref = element.getAttribute("ref");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AggregatingMessageHandler.class);
        BeanDefinitionBuilder processorBuilder = null;
        Object processor = null;
        if (innerHandlerDefinition != null || StringUtils.hasText((String)ref)) {
            processorBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingMessageGroupProcessor.class);
            builder.addConstructorArgValue((Object)processorBuilder.getBeanDefinition());
            processor = innerHandlerDefinition != null ? innerHandlerDefinition : new RuntimeBeanReference(ref);
            processorBuilder.addConstructorArgValue(processor);
        } else if (StringUtils.hasText((String)element.getAttribute("expression"))) {
            String expression = element.getAttribute("expression");
            BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionEvaluatingMessageGroupProcessor.class);
            adapterBuilder.addConstructorArgValue((Object)expression);
            builder.addConstructorArgValue((Object)adapterBuilder.getBeanDefinition());
        } else {
            builder.addConstructorArgValue((Object)BeanDefinitionBuilder.genericBeanDefinition(DefaultAggregatingMessageGroupProcessor.class).getBeanDefinition());
        }
        if (StringUtils.hasText((String)element.getAttribute("method"))) {
            String method = element.getAttribute("method");
            processorBuilder.getRawBeanDefinition().getConstructorArgumentValues().addGenericArgumentValue((Object)method, "java.lang.String");
        }
        this.doParse(builder, element, (BeanMetadataElement)processor, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, EXPIRE_GROUPS_UPON_COMPLETION);
        this.injectPropertyWithAdapter(RELEASE_STRATEGY_REF_ATTRIBUTE, RELEASE_STRATEGY_METHOD_ATTRIBUTE, RELEASE_STRATEGY_EXPRESSION_ATTRIBUTE, RELEASE_STRATEGY_PROPERTY, "ReleaseStrategy", element, builder, (BeanMetadataElement)processor, parserContext);
        return builder;
    }
}

