/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChainParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.handler.MessageHandlerChain");
        ManagedList handlerList = new ManagedList();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || "poller".equals(child.getLocalName())) continue;
            BeanDefinitionHolder holder = this.parseChild((Element)child, parserContext, (BeanDefinition)builder.getBeanDefinition());
            if ("gateway".equals(child.getLocalName())) {
                BeanDefinitionBuilder gwBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.gateway.RequestReplyMessageHandlerAdapter");
                gwBuilder.addConstructorArgValue((Object)holder);
                handlerList.add((Object)gwBuilder.getBeanDefinition());
                continue;
            }
            handlerList.add((Object)holder);
        }
        builder.addPropertyValue("handlers", (Object)handlerList);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "send-timeout");
        return builder;
    }

    private BeanDefinitionHolder parseChild(Element element, ParserContext parserContext, BeanDefinition parentDefinition) {
        BeanDefinitionHolder holder = null;
        if (element.getLocalName().equals("bean")) {
            holder = parserContext.getDelegate().parseBeanDefinitionElement(element, parentDefinition);
        } else {
            BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(element, parentDefinition);
            if (beanDefinition == null) {
                parserContext.getReaderContext().error("child BeanDefinition must not be null", (Object)element);
            } else {
                String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)true);
                holder = new BeanDefinitionHolder(beanDefinition, beanName);
            }
        }
        return holder;
    }
}

