/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.util.Assert;

final class ChannelInitializer
implements BeanFactoryAware,
InitializingBean {
    public static String AUTO_CREATE_CHANNEL_CANDIDATES_BEAN_NAME = "$autoCreateChannelCandidates";
    public static String CHANNEL_NAMES_ATTR = "channelNames";
    private Log logger = LogFactory.getLog(this.getClass());
    private volatile BeanFactory beanFactory;
    private volatile boolean autoCreate = true;

    ChannelInitializer() {
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"'beanFactory' must not be null");
        if (!this.autoCreate) {
            return;
        }
        AutoCreateCandidatesCollector channelCandidatesCollector = (AutoCreateCandidatesCollector)this.beanFactory.getBean(AUTO_CREATE_CHANNEL_CANDIDATES_BEAN_NAME, AutoCreateCandidatesCollector.class);
        Assert.notNull((Object)channelCandidatesCollector, (String)("Failed to locate '" + AUTO_CREATE_CHANNEL_CANDIDATES_BEAN_NAME));
        Collection<String> channelNames = channelCandidatesCollector.getChannelNames();
        if (channelNames != null) {
            for (String channelName : channelNames) {
                if (this.beanFactory.containsBean(channelName)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Auto-creating channel '" + channelName + "' as DirectChannel"));
                }
                RootBeanDefinition messageChannel = new RootBeanDefinition();
                messageChannel.setBeanClass(DirectChannel.class);
                BeanDefinitionHolder messageChannelHolder = new BeanDefinitionHolder((BeanDefinition)messageChannel, channelName);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)messageChannelHolder, (BeanDefinitionRegistry)((BeanDefinitionRegistry)this.beanFactory));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AutoCreateCandidatesCollector {
        private final Collection<String> channelNames;

        public AutoCreateCandidatesCollector(Collection<String> channelNames) {
            this.channelNames = channelNames;
        }

        public Collection<String> getChannelNames() {
            return this.channelNames;
        }
    }
}

