/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.handler.ExpressionEvaluatingMessageHandler;
import org.springframework.integration.handler.MethodInvokingMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DefaultOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected String parseAndRegisterConsumer(Element element, ParserContext parserContext) {
        BeanComponentDefinition innerConsumerDefinition = IntegrationNamespaceUtils.parseInnerHandlerDefinition(element, parserContext);
        String consumerRef = element.getAttribute("ref");
        String methodName = element.getAttribute("method");
        String consumerExpressionString = element.getAttribute("expression");
        boolean isInnerConsumer = innerConsumerDefinition != null;
        boolean isRef = StringUtils.hasText((String)consumerRef);
        boolean isExpression = StringUtils.hasText((String)consumerExpressionString);
        boolean hasMethod = StringUtils.hasText((String)methodName);
        if (!(isInnerConsumer ^ (isRef ^ isExpression))) {
            parserContext.getReaderContext().error("Exactly one of the 'ref', 'expression' or inner bean is required.", (Object)element);
        }
        if (hasMethod & isExpression) {
            parserContext.getReaderContext().error("The 'method' attribute cannot be used with the 'expression' attribute.", (Object)element);
        }
        if (hasMethod | isExpression) {
            BeanDefinitionBuilder consumerBuilder = null;
            if (hasMethod) {
                consumerBuilder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingMessageHandler.class);
                if (isRef) {
                    consumerBuilder.addConstructorArgReference(consumerRef);
                } else {
                    consumerBuilder.addConstructorArgValue((Object)innerConsumerDefinition);
                }
                consumerBuilder.addConstructorArgValue((Object)methodName);
            } else {
                consumerBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionEvaluatingMessageHandler.class);
                RootBeanDefinition expressionDef = new RootBeanDefinition(ExpressionFactoryBean.class);
                expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)consumerExpressionString);
                consumerBuilder.addConstructorArgValue((Object)expressionDef);
            }
            consumerBuilder.addPropertyValue("componentType", (Object)"outbound-channel-adapter");
            String order = element.getAttribute("order");
            if (StringUtils.hasText((String)order)) {
                consumerBuilder.addPropertyValue("order", (Object)order);
            }
            consumerRef = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)consumerBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        } else if (isInnerConsumer) {
            consumerRef = innerConsumerDefinition.getBeanName();
        }
        Assert.hasText((String)consumerRef, (String)"cannot determine consumer for 'outbound-channel-adapter'");
        return consumerRef;
    }

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        throw new UnsupportedOperationException();
    }
}

