/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class DelayerParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.handler.DelayHandler");
        String defaultDelay = element.getAttribute("default-delay");
        if (!StringUtils.hasText((String)defaultDelay)) {
            parserContext.getReaderContext().error("The 'default-delay' attribute is required.", (Object)element);
            return null;
        }
        builder.addConstructorArgValue((Object)defaultDelay);
        String scheduler = element.getAttribute("scheduler");
        if (StringUtils.hasText((String)scheduler)) {
            builder.addConstructorArgReference(scheduler);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "message-store");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "delay-header-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "send-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "wait-for-tasks-to-complete-on-shutdown");
        return builder;
    }
}

