/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegrationNamespaceUtils {
    static final String BASE_PACKAGE = "org.springframework.integration";
    static final String REF_ATTRIBUTE = "ref";
    static final String METHOD_ATTRIBUTE = "method";
    static final String ORDER = "order";
    static final String EXPRESSION_ATTRIBUTE = "expression";

    public static void setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyValue(propertyName, (Object)new TypedStringValue(attributeValue));
        }
    }

    public static void setValueIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    public static void setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyReference(propertyName, attributeValue);
        }
    }

    public static void setReferenceIfAttributeDefined(BeanDefinitionBuilder builder, Element element, String attributeName) {
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    public static String createElementDescription(Element element) {
        String elementId = "'" + element.getNodeName() + "'";
        String id = element.getAttribute("id");
        if (StringUtils.hasText((String)id)) {
            elementId = elementId + " with id='" + id + "'";
        }
        return elementId;
    }

    public static void configurePollerMetadata(Element pollerElement, BeanDefinitionBuilder targetBuilder, ParserContext parserContext) {
        if (pollerElement.hasAttribute(REF_ATTRIBUTE)) {
            int numberOfAttributes = pollerElement.getAttributes().getLength();
            if (!(numberOfAttributes == 1 || numberOfAttributes == 2 && pollerElement.hasAttribute("default") && pollerElement.getAttribute("default").equals("false"))) {
                parserContext.getReaderContext().error("A 'poller' element that provides a 'ref' must have no other attributes.", (Object)pollerElement);
            }
            if (pollerElement.getChildNodes().getLength() != 0) {
                parserContext.getReaderContext().error("A 'poller' element that provides a 'ref' must have no child elements.", (Object)pollerElement);
            }
            targetBuilder.addPropertyReference("pollerMetadata", pollerElement.getAttribute(REF_ATTRIBUTE));
        } else {
            BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(pollerElement, (BeanDefinition)targetBuilder.getBeanDefinition());
            if (beanDefinition == null) {
                parserContext.getReaderContext().error("BeanDefinition must not be null", (Object)pollerElement);
            }
            targetBuilder.addPropertyValue("pollerMetadata", (Object)beanDefinition);
        }
    }

    public static String getTextFromAttributeOrNestedElement(Element element, String name, ParserContext parserContext) {
        String attr = element.getAttribute(name);
        Element childElement = DomUtils.getChildElementByTagName((Element)element, (String)name);
        if (StringUtils.hasText((String)attr) && childElement != null) {
            parserContext.getReaderContext().error("Either an attribute or a child element can be specified for " + name + " but not both", (Object)element);
            return null;
        }
        if (!StringUtils.hasText((String)attr) && childElement == null) {
            return null;
        }
        return StringUtils.hasText((String)attr) ? attr : childElement.getTextContent();
    }

    public static BeanComponentDefinition parseInnerHandlerDefinition(Element element, ParserContext parserContext) {
        String ref;
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"bean");
        String innerComponentDefinition = null;
        if (childElements != null && childElements.size() == 1) {
            Element beanElement = (Element)childElements.get(0);
            BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
            BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(beanElement);
            bdHolder = delegate.decorateBeanDefinitionIfRequired(beanElement, bdHolder);
            BeanDefinition inDef = bdHolder.getBeanDefinition();
            innerComponentDefinition = new BeanComponentDefinition(inDef, bdHolder.getBeanName());
        }
        Assert.isTrue((!StringUtils.hasText((String)(ref = element.getAttribute(REF_ATTRIBUTE))) || innerComponentDefinition == null ? 1 : 0) != 0, (String)("Ambiguous definition. Inner bean " + (innerComponentDefinition == null ? innerComponentDefinition : innerComponentDefinition.getBeanDefinition().getBeanClassName()) + " declaration and \"ref\" " + ref + " are not allowed together."));
        return innerComponentDefinition;
    }

    public static void configureHeaderMapper(Element element, BeanDefinitionBuilder rootBuilder, ParserContext parserContext, Class<?> headerMapperClass, String replyHeaderValue) {
        String defaultMappedReplyHeadersAttributeName = "mapped-reply-headers";
        if (!StringUtils.hasText((String)replyHeaderValue)) {
            replyHeaderValue = defaultMappedReplyHeadersAttributeName;
        }
        boolean hasHeaderMapper = element.hasAttribute("header-mapper");
        boolean hasMappedRequestHeaders = element.hasAttribute("mapped-request-headers");
        boolean hasMappedReplyHeaders = element.hasAttribute(replyHeaderValue);
        if (hasHeaderMapper && (hasMappedRequestHeaders || hasMappedReplyHeaders)) {
            parserContext.getReaderContext().error("The 'header-mapper' attribute is mutually exclusive with 'mapped-request-headers' or 'mapped-reply-headers'. You can only use one or the others", (Object)element);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(rootBuilder, element, "header-mapper");
        if (hasMappedRequestHeaders || hasMappedReplyHeaders) {
            BeanDefinitionBuilder headerMapperBuilder = BeanDefinitionBuilder.genericBeanDefinition(headerMapperClass);
            if (hasMappedRequestHeaders) {
                headerMapperBuilder.addPropertyValue("requestHeaderNames", (Object)element.getAttribute("mapped-request-headers"));
            }
            if (hasMappedReplyHeaders) {
                headerMapperBuilder.addPropertyValue("replyHeaderNames", (Object)element.getAttribute(replyHeaderValue));
            }
            rootBuilder.addPropertyValue("headerMapper", (Object)headerMapperBuilder.getBeanDefinition());
        }
    }
}

