/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.ExecutorChannel;
import org.springframework.integration.channel.PriorityChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.channel.RendezvousChannel;
import org.springframework.integration.config.xml.AbstractChannelParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.store.MessageGroupQueue;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PointToPointChannelParser
extends AbstractChannelParser {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected BeanDefinitionBuilder buildBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = null;
        Element queueElement = null;
        queueElement = DomUtils.getChildElementByTagName((Element)element, (String)"queue");
        if (queueElement != null) {
            boolean hasCapacity;
            builder = BeanDefinitionBuilder.genericBeanDefinition(QueueChannel.class);
            boolean hasStoreRef = this.parseStoreRef(builder, queueElement, element.getAttribute("id"));
            boolean hasQueueRef = this.parseQueueRef(builder, queueElement);
            if (!hasStoreRef && (hasCapacity = this.parseQueueCapacity(builder, queueElement)) && hasQueueRef) {
                parserContext.getReaderContext().error("The 'capacity' attribute is not allowed when providing a 'ref' to a custom queue.", (Object)element);
            }
            if (hasStoreRef && hasQueueRef) {
                parserContext.getReaderContext().error("The 'message-store' attribute is not allowed when providing a 'ref' to a custom queue.", (Object)element);
            }
        } else {
            queueElement = DomUtils.getChildElementByTagName((Element)element, (String)"priority-queue");
            if (queueElement != null) {
                builder = BeanDefinitionBuilder.genericBeanDefinition(PriorityChannel.class);
                this.parseQueueCapacity(builder, queueElement);
                String comparatorRef = queueElement.getAttribute("comparator");
                if (StringUtils.hasText((String)comparatorRef)) {
                    builder.addConstructorArgReference(comparatorRef);
                }
            } else {
                queueElement = DomUtils.getChildElementByTagName((Element)element, (String)"rendezvous-queue");
                if (queueElement != null) {
                    builder = BeanDefinitionBuilder.genericBeanDefinition(RendezvousChannel.class);
                }
            }
        }
        Element dispatcherElement = DomUtils.getChildElementByTagName((Element)element, (String)"dispatcher");
        String dispatcherAttribute = element.getAttribute("dispatcher");
        boolean hasDispatcherAttribute = StringUtils.hasText((String)dispatcherAttribute);
        if (hasDispatcherAttribute && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"The 'dispatcher' attribute on the 'channel' element is deprecated. Please use the 'dispatcher' sub-element instead.");
        }
        if (queueElement != null && (dispatcherElement != null || hasDispatcherAttribute)) {
            parserContext.getReaderContext().error("The 'dispatcher' attribute or sub-element and any queue sub-element are mutually exclusive.", (Object)element);
            return null;
        }
        if (queueElement != null) {
            return builder;
        }
        if (dispatcherElement != null && hasDispatcherAttribute) {
            parserContext.getReaderContext().error("The 'dispatcher' attribute and 'dispatcher' sub-element are mutually exclusive. NOTE: the attribute is DEPRECATED. Please use the dispatcher sub-element instead.", (Object)element);
            return null;
        }
        if (hasDispatcherAttribute) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
            if ("failover".equals(dispatcherAttribute)) {
                builder.addConstructorArgValue(null);
            }
        } else if (dispatcherElement == null) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
        } else {
            String taskExecutor = dispatcherElement.getAttribute("task-executor");
            if (StringUtils.hasText((String)taskExecutor)) {
                builder = BeanDefinitionBuilder.genericBeanDefinition(ExecutorChannel.class);
                builder.addConstructorArgReference(taskExecutor);
            } else {
                builder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
            }
            String loadBalancer = dispatcherElement.getAttribute("load-balancer");
            if ("none".equals(loadBalancer)) {
                builder.addConstructorArgValue(null);
            }
            IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, dispatcherElement, "failover");
        }
        return builder;
    }

    private boolean parseQueueCapacity(BeanDefinitionBuilder builder, Element queueElement) {
        String capacity = queueElement.getAttribute("capacity");
        if (StringUtils.hasText((String)capacity)) {
            builder.addConstructorArgValue((Object)capacity);
            return true;
        }
        return false;
    }

    private boolean parseQueueRef(BeanDefinitionBuilder builder, Element queueElement) {
        String queueRef = queueElement.getAttribute("ref");
        if (StringUtils.hasText((String)queueRef)) {
            builder.addConstructorArgReference(queueRef);
            return true;
        }
        return false;
    }

    private boolean parseStoreRef(BeanDefinitionBuilder builder, Element queueElement, String channel) {
        String storeRef = queueElement.getAttribute("message-store");
        if (StringUtils.hasText((String)storeRef)) {
            BeanDefinitionBuilder queueBuilder = BeanDefinitionBuilder.genericBeanDefinition(MessageGroupQueue.class);
            queueBuilder.addConstructorArgReference(storeRef);
            queueBuilder.addConstructorArgValue((Object)(new TypedStringValue(storeRef).getValue() + ":" + channel));
            this.parseQueueCapacity(queueBuilder, queueElement);
            builder.addConstructorArgValue((Object)queueBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }
}

