/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.MatchAlwaysTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PollerParser
extends AbstractBeanDefinitionParser {
    private static final String MULTIPLE_TRIGGER_DEFINITIONS = "A <poller> cannot specify more than one trigger configuration.";
    private static final String NO_TRIGGER_DEFINITIONS = "A <poller> must have one and only one trigger configuration.";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (element.getAttribute("default").equals("true")) {
            if (parserContext.getRegistry().isBeanNameInUse("org.springframework.integration.context.defaultPollerMetadata")) {
                parserContext.getReaderContext().error("Only one default <poller/> element is allowed per context.", (Object)element);
            }
            if (StringUtils.hasText((String)id)) {
                parserContext.getRegistry().registerAlias(id, "org.springframework.integration.context.defaultPollerMetadata");
            } else {
                id = "org.springframework.integration.context.defaultPollerMetadata";
            }
        } else if (!StringUtils.hasText((String)id)) {
            parserContext.getReaderContext().error("The 'id' attribute is required for a top-level poller element unless it is the default poller.", (Object)element);
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder metadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(PollerMetadata.class);
        if (element.hasAttribute("ref")) {
            parserContext.getReaderContext().error("the 'ref' attribute must not be present on the top-level 'poller' element", (Object)element);
        }
        this.configureTrigger(element, metadataBuilder, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(metadataBuilder, element, "max-messages-per-poll");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(metadataBuilder, element, "receive-timeout");
        Element txElement = DomUtils.getChildElementByTagName((Element)element, (String)"transactional");
        Element adviceChainElement = DomUtils.getChildElementByTagName((Element)element, (String)"advice-chain");
        this.configureAdviceChain(adviceChainElement, txElement, metadataBuilder, parserContext);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(metadataBuilder, element, "task-executor");
        String errorChannel = element.getAttribute("error-channel");
        if (StringUtils.hasText((String)errorChannel)) {
            BeanDefinitionBuilder errorHandler = BeanDefinitionBuilder.genericBeanDefinition(MessagePublishingErrorHandler.class);
            errorHandler.addPropertyReference("defaultErrorChannel", errorChannel);
            metadataBuilder.addPropertyValue("errorHandler", (Object)errorHandler.getBeanDefinition());
        }
        return metadataBuilder.getBeanDefinition();
    }

    private void configureTrigger(Element pollerElement, BeanDefinitionBuilder targetBuilder, ParserContext parserContext) {
        String triggerBeanName;
        BeanDefinitionBuilder builder;
        String triggerAttribute = pollerElement.getAttribute("trigger");
        String fixedRateAttribute = pollerElement.getAttribute("fixed-rate");
        String fixedDelayAttribute = pollerElement.getAttribute("fixed-delay");
        String cronAttribute = pollerElement.getAttribute("cron");
        String timeUnit = pollerElement.getAttribute("time-unit");
        ArrayList<String> triggerBeanNames = new ArrayList<String>();
        if (StringUtils.hasText((String)triggerAttribute)) {
            if (StringUtils.hasText((String)timeUnit)) {
                parserContext.getReaderContext().error("The 'time-unit' attribute cannot be used with a 'trigger' reference.", (Object)pollerElement);
            }
            triggerBeanNames.add(triggerAttribute);
        }
        if (StringUtils.hasText((String)fixedRateAttribute)) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(PeriodicTrigger.class);
            builder.addConstructorArgValue((Object)fixedRateAttribute);
            if (StringUtils.hasText((String)timeUnit)) {
                builder.addConstructorArgValue((Object)timeUnit);
            }
            builder.addPropertyValue("fixedRate", (Object)Boolean.TRUE);
            triggerBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            triggerBeanNames.add(triggerBeanName);
        }
        if (StringUtils.hasText((String)fixedDelayAttribute)) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(PeriodicTrigger.class);
            builder.addConstructorArgValue((Object)fixedDelayAttribute);
            if (StringUtils.hasText((String)timeUnit)) {
                builder.addConstructorArgValue((Object)timeUnit);
            }
            builder.addPropertyValue("fixedRate", (Object)Boolean.FALSE);
            triggerBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            triggerBeanNames.add(triggerBeanName);
        }
        if (StringUtils.hasText((String)cronAttribute)) {
            if (StringUtils.hasText((String)timeUnit)) {
                parserContext.getReaderContext().error("The 'time-unit' attribute cannot be used with a 'cron' trigger.", (Object)pollerElement);
            }
            builder = BeanDefinitionBuilder.genericBeanDefinition(CronTrigger.class);
            builder.addConstructorArgValue((Object)cronAttribute);
            triggerBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
            triggerBeanNames.add(triggerBeanName);
        }
        if (triggerBeanNames.isEmpty()) {
            parserContext.getReaderContext().error(NO_TRIGGER_DEFINITIONS, (Object)pollerElement);
        }
        if (triggerBeanNames.size() > 1) {
            parserContext.getReaderContext().error(MULTIPLE_TRIGGER_DEFINITIONS, (Object)pollerElement);
        }
        targetBuilder.addPropertyReference("trigger", (String)triggerBeanNames.get(0));
    }

    private BeanDefinition configureTransactionAttributes(Element txElement) {
        BeanDefinitionBuilder txDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultTransactionAttribute.class);
        txDefinitionBuilder.addPropertyValue("propagationBehaviorName", (Object)("PROPAGATION_" + txElement.getAttribute("propagation")));
        txDefinitionBuilder.addPropertyValue("isolationLevelName", (Object)("ISOLATION_" + txElement.getAttribute("isolation")));
        txDefinitionBuilder.addPropertyValue("timeout", (Object)txElement.getAttribute("timeout"));
        txDefinitionBuilder.addPropertyValue("readOnly", (Object)txElement.getAttribute("read-only"));
        BeanDefinitionBuilder attributeSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(MatchAlwaysTransactionAttributeSource.class);
        attributeSourceBuilder.addPropertyValue("transactionAttribute", (Object)txDefinitionBuilder.getBeanDefinition());
        BeanDefinitionBuilder txInterceptorBuilder = BeanDefinitionBuilder.genericBeanDefinition(TransactionInterceptor.class);
        txInterceptorBuilder.addPropertyReference("transactionManager", txElement.getAttribute("transaction-manager"));
        txInterceptorBuilder.addPropertyValue("transactionAttributeSource", (Object)attributeSourceBuilder.getBeanDefinition());
        return txInterceptorBuilder.getBeanDefinition();
    }

    private void configureAdviceChain(Element adviceChainElement, Element txElement, BeanDefinitionBuilder targetBuilder, ParserContext parserContext) {
        ManagedList adviceChain = new ManagedList();
        if (txElement != null) {
            adviceChain.add((Object)this.configureTransactionAttributes(txElement));
        }
        if (adviceChainElement != null) {
            NodeList childNodes = adviceChainElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if ("bean".equals(localName)) {
                    BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(childElement, (BeanDefinition)targetBuilder.getBeanDefinition());
                    parserContext.registerBeanComponent(new BeanComponentDefinition(holder));
                    adviceChain.add((Object)new RuntimeBeanReference(holder.getBeanName()));
                    continue;
                }
                if ("ref".equals(localName)) {
                    String ref = childElement.getAttribute("bean");
                    adviceChain.add((Object)new RuntimeBeanReference(ref));
                    continue;
                }
                BeanDefinition customBeanDefinition = parserContext.getDelegate().parseCustomElement(childElement, (BeanDefinition)targetBuilder.getBeanDefinition());
                if (customBeanDefinition == null) {
                    parserContext.getReaderContext().error("failed to parse custom element '" + localName + "'", (Object)childElement);
                }
                adviceChain.add((Object)customBeanDefinition);
            }
        }
        targetBuilder.addPropertyValue("adviceChain", (Object)adviceChain);
    }
}

