/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class RecipientListRouterParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder recipientListRouterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.router.RecipientListRouter");
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"recipient");
        Assert.notEmpty((Collection)childElements, (String)"At least one recipient channel must be defined (e.g., <recipient channel=\"channel1\"/>).");
        ManagedList recipientList = new ManagedList();
        for (Element childElement : childElements) {
            BeanDefinitionBuilder recipientBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.router.RecipientListRouter.Recipient");
            recipientBuilder.addConstructorArgReference(childElement.getAttribute("channel"));
            String expression = childElement.getAttribute("selector-expression");
            if (StringUtils.hasText((String)expression)) {
                RootBeanDefinition selectorDef = new RootBeanDefinition("org.springframework.integration.filter.ExpressionEvaluatingSelector");
                selectorDef.getConstructorArgumentValues().addGenericArgumentValue((Object)expression);
                String selectorBeanName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)selectorDef);
                recipientBuilder.addConstructorArgReference(selectorBeanName);
            }
            recipientList.add((Object)recipientBuilder.getBeanDefinition());
        }
        recipientListRouterBuilder.addPropertyValue("recipients", (Object)recipientList);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(recipientListRouterBuilder, element, "timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(recipientListRouterBuilder, element, "ignore-send-failures");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(recipientListRouterBuilder, element, "apply-sequence");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(recipientListRouterBuilder, element, "default-output-channel");
        return recipientListRouterBuilder;
    }
}

