/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.resource.ResourceRetrievingMessageSource;
import org.springframework.integration.util.AcceptOnceCollectionFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ResourceInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder sourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(ResourceRetrievingMessageSource.class);
        sourceBuilder.addConstructorArgValue((Object)element.getAttribute("pattern"));
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(sourceBuilder, element, "pattern-resolver");
        boolean hasFilter = element.hasAttribute("filter");
        if (hasFilter) {
            String filterValue = element.getAttribute("filter");
            if (StringUtils.hasText((String)filterValue)) {
                sourceBuilder.addPropertyReference("filter", filterValue);
            }
        } else {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition(AcceptOnceCollectionFilter.class);
            sourceBuilder.addPropertyValue("filter", (Object)filterBuilder.getBeanDefinition());
        }
        return sourceBuilder.getBeanDefinition();
    }
}

