/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.context;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.store.MetadataStore;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegrationContextUtils {
    public static final String TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    public static final String ERROR_CHANNEL_BEAN_NAME = "errorChannel";
    public static final String NULL_CHANNEL_BEAN_NAME = "nullChannel";
    public static final String METADATA_STORE_BEAN_NAME = "metadataStore";
    public static final String INTEGRATION_CONVERSION_SERVICE_BEAN_NAME = "integrationConversionService";
    public static final String DEFAULT_POLLER_METADATA_BEAN_NAME = "org.springframework.integration.context.defaultPollerMetadata";

    public static MetadataStore getMetadataStore(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, METADATA_STORE_BEAN_NAME, MetadataStore.class);
    }

    public static MessageChannel getErrorChannel(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, ERROR_CHANNEL_BEAN_NAME, MessageChannel.class);
    }

    public static TaskScheduler getTaskScheduler(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, TASK_SCHEDULER_BEAN_NAME, TaskScheduler.class);
    }

    public static TaskScheduler getRequiredTaskScheduler(BeanFactory beanFactory) {
        TaskScheduler taskScheduler = IntegrationContextUtils.getTaskScheduler(beanFactory);
        Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"No such bean 'taskScheduler'");
        return taskScheduler;
    }

    public static PollerMetadata getDefaultPollerMetadata(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, DEFAULT_POLLER_METADATA_BEAN_NAME, PollerMetadata.class);
    }

    public static ConversionService getConversionService(BeanFactory beanFactory) {
        return IntegrationContextUtils.getBeanOfType(beanFactory, INTEGRATION_CONVERSION_SERVICE_BEAN_NAME, ConversionService.class);
    }

    private static <T> T getBeanOfType(BeanFactory beanFactory, String beanName, Class<T> type) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        if (!beanFactory.containsBean(beanName)) {
            return null;
        }
        return (T)beanFactory.getBean(beanName, type);
    }
}

